/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.BeanQLViewStatementSupport;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.exceptions.BeanQLResultEmptyException;
import jp.co.powerbeans.beanql.exceptions.BeanQLResultMultiException;

public class BeanQLSimpleViewStatement
extends BeanQLViewStatementSupport {
    private Statement statement;

    public BeanQLSimpleViewStatement(Class bean_class, Statement statement, BeanQLTransaction super_tr) throws BeanQLException {
        this.bean = bean_class;
        this.statement = statement;
        this.createBeanFieldListMap();
    }

    public Collection select(String sql) throws BeanQLException, SQLException {
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.statement.executeQuery(sql.toString());
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public Object selectOne(String sql) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        Collection col = this.select(sql);
        if (col.isEmpty()) {
            throw new BeanQLResultEmptyException("\u691c\u7d22\u7d50\u679c 0\u4ef6");
        }
        if (col.size() > 1) {
            throw new BeanQLResultMultiException("\u691c\u7d22\u7d50\u679c " + col.size() + "\u4ef6");
        }
        Object o = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public void close() throws BeanQLException {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                throw new BeanQLException(e);
            }
        }
    }

    public static void closeSafe(BeanQLSimpleViewStatement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (BeanQLException e) {
            e.printStackTrace();
        }
    }
}

