/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.co.powerbeans.beanql.BeanProperty;
import jp.co.powerbeans.beanql.BeanQLPreparedStatement;
import jp.co.powerbeans.beanql.BeanQLStatementIF;
import jp.co.powerbeans.beanql.BeanQLStatementSupport;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.BeanQLUtil;
import jp.co.powerbeans.beanql.CPCache;
import jp.co.powerbeans.beanql.ColumnProperty;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.exceptions.BeanQLExclusiveException;
import jp.co.powerbeans.beanql.exceptions.BeanQLResultEmptyException;
import jp.co.powerbeans.beanql.exceptions.BeanQLResultMultiException;
import jp.co.powerbeans.beanql.exceptions.BeanQLTableNotFoundException;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatement;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatementFactory;

public class BeanQLStatement
extends BeanQLStatementSupport {
    private Statement statement;

    BeanQLStatement(Class bean_class, Statement statement, BeanQLTransaction super_tr) throws BeanQLException, BeanQLTableNotFoundException {
        this.bean = bean_class;
        this.statement = statement;
        this.super_tr = super_tr;
        this.tableName = BeanQLUtil.className2TableName(this.bean);
        try {
            this.createSQLMapping();
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public Collection selectAll() throws BeanQLException, SQLException {
        return this.selectAll("");
    }

    public Collection selectAll(String order_by) throws SQLException, BeanQLException {
        StringBuffer sql = new StringBuffer("SELECT * FROM " + this.getTableName());
        if (order_by != null && order_by.length() > 0) {
            sql.append(" ORDER BY " + order_by);
        }
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.statement.executeQuery(sql.toString());
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public Collection select(String where) throws SQLException, BeanQLException {
        return this.select(where, "", "");
    }

    public Collection select(String where, String groupby) throws SQLException, BeanQLException {
        return this.select(where, groupby, "");
    }

    public Collection select(String where, String groupby, String orderby) throws SQLException, BeanQLException {
        DBDependQLStatement dqs = DBDependQLStatementFactory.create(this.statement.getConnection(), this.super_tr.mgr);
        String sql = dqs.getSelectSQL(this.getTableName(), this.bpList, where, groupby, orderby);
        ArrayList<Object> result_list = new ArrayList<Object>();
        ResultSet result = this.statement.executeQuery(sql);
        while (result.next()) {
            result_list.add(this.getBeanByResultSet(result));
        }
        result.close();
        return result_list;
    }

    public int insert(Object o) throws BeanQLException, SQLException {
        BeanProperty bp;
        this.validateBean(o);
        DBDependQLStatement dep = DBDependQLStatementFactory.create(this.super_tr.getConnection(), this.super_tr.mgr);
        StringBuffer sql = new StringBuffer("INSERT INTO " + this.getTableName() + " (");
        int c = 0;
        Iterator bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            bp = (BeanProperty)bpit.next();
            if (bp.getColumnProp().isNotUseInsertSql()) continue;
            if (c++ > 0) {
                sql.append(",");
            }
            sql.append(bp.getColumnProp().getName());
        }
        sql.append(") VALUES (");
        c = 0;
        bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            bp = (BeanProperty)bpit.next();
            Object val = this.getValueByType(o, bp);
            if (bp.getColumnProp().isNotUseInsertSql()) continue;
            if (c > 0) {
                sql.append(",");
            }
            sql.append(BeanQLStatementSupport.formatVal(val, bp.getColumnProp().getTypeAsDB(), dep));
            ++c;
        }
        sql.append(")");
        if (c == 0) {
            throw new BeanQLException("don't get Column");
        }
        return this.statement.executeUpdate(sql.toString());
    }

    public int delete(Object o) throws BeanQLException, SQLException {
        this.validateBean(o);
        StringBuffer sql = new StringBuffer("DELETE FROM " + this.getTableName() + " WHERE ");
        String where = null;
        Iterator bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            if (!bp.getColumnProp().isPrimaryKey()) continue;
            Object val = this.getValueByType(o, bp);
            where = String.valueOf(bp.getName()) + " = " + BeanQLStatementSupport.formatVal(val);
            break;
        }
        if (where == null) {
            throw new BeanQLException("cannot get Primary Key Column of :" + this.tableName);
        }
        sql.append(where);
        return this.statement.executeUpdate(sql.toString());
    }

    public int delete(String where) throws BeanQLException, SQLException {
        StringBuffer sql = new StringBuffer("DELETE FROM " + this.getTableName());
        if (where != null && where.trim().length() > 0) {
            sql.append(" WHERE " + where);
        }
        return this.statement.executeUpdate(sql.toString());
    }

    public int update(Object o) throws BeanQLException, SQLException {
        return this.update(o, "");
    }

    public int update(Object o, String where) throws BeanQLException, SQLException {
        this.validateBean(o);
        StringBuffer sql = new StringBuffer("UPDATE " + this.getTableName() + " SET ");
        int c = 0;
        Iterator bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            if (bp.getColumnProp().isPrimaryKey()) continue;
            Object val = this.getValueByType(o, bp);
            if (c > 0) {
                sql.append(",");
            }
            sql.append(String.valueOf(bp.getName()) + "=" + BeanQLStatementSupport.formatVal(val));
            ++c;
        }
        if (c == 0) {
            throw new BeanQLException("don't get Column");
        }
        sql.append(" WHERE ");
        int pc = 0;
        Iterator bpit2 = this.bpList.iterator();
        while (bpit2.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit2.next();
            if (!bp.getColumnProp().isPrimaryKey()) continue;
            if (pc > 0) {
                sql.append(",");
            }
            Object val = this.getValueByType(o, bp);
            sql.append(String.valueOf(bp.getName()) + " = " + BeanQLStatementSupport.formatVal(val));
        }
        if (where != null && where.trim().length() > 0) {
            sql.append(" AND " + where.trim());
        }
        return this.statement.executeUpdate(sql.toString());
    }

    public int getNextSequence() throws BeanQLException {
        try {
            Class<?> clazz = this.bean.getClass();
            synchronized (clazz) {
                StringBuffer sql_select = new StringBuffer(" SELECT sequence  FROM " + this.super_tr.mgr.getSequenceTable() + " WHERE tableName = '" + this.getTableName() + "'");
                ArrayList cp_list = CPCache.getColumnPropertyList(this.super_tr.getConnection(), this.super_tr.mgr, this.getTableName());
                ColumnProperty cp = null;
                Iterator it = cp_list.iterator();
                while (it.hasNext()) {
                    ColumnProperty cpw = (ColumnProperty)it.next();
                    if (!cpw.isPrimaryKey()) continue;
                    cp = cpw;
                    break;
                }
                if (cp == null) {
                    throw new BeanQLException("finding seq PK. but PK not found");
                }
                StringBuffer sql_select_max = new StringBuffer(" SELECT MAX(" + cp.getName() + ")" + " FROM " + this.getTableName());
                int check_c = 0;
                int now_seq = 0;
                int table_max_seq = 0;
                ResultSet result_c = this.statement.executeQuery(sql_select.toString());
                if (result_c.next()) {
                    ++check_c;
                    now_seq = result_c.getInt(1);
                }
                result_c.close();
                ResultSet result = this.statement.executeQuery(sql_select_max.toString());
                if (result.next()) {
                    table_max_seq = result.getInt(1);
                }
                result.close();
                if (check_c == 0) {
                    now_seq = table_max_seq;
                    if (check_c == 0) {
                        StringBuffer sql_insert = new StringBuffer("INSERT INTO " + this.super_tr.mgr.getSequenceTable() + " VALUES('" + this.getTableName() + "'," + now_seq + ")");
                        this.statement.executeUpdate(sql_insert.toString());
                    }
                } else {
                    now_seq = now_seq > table_max_seq ? now_seq : table_max_seq;
                }
                boolean is_auto_commit = this.super_tr.getConnection().getAutoCommit();
                this.super_tr.setAutoCommit(false);
                StringBuffer sql_update = new StringBuffer(" UPDATE " + this.super_tr.mgr.getSequenceTable() + " SET sequence = " + (now_seq + 1) + " WHERE tableName = '" + this.getTableName() + "'");
                int c = this.statement.executeUpdate(sql_update.toString());
                if (c == 0) {
                    throw new BeanQLException("cannot update sequence");
                }
                ResultSet result2 = this.statement.executeQuery(sql_select.toString());
                int sequence_val = 0;
                if (result2.next()) {
                    sequence_val = result2.getInt(1);
                }
                result2.close();
                this.super_tr.commit();
                this.super_tr.setAutoCommit(is_auto_commit);
                return sequence_val;
            }
        }
        catch (SQLException e) {
            this.super_tr.rollback();
            e.printStackTrace();
            throw new BeanQLException(e);
        }
    }

    public Object selectOne(String where) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        return this.selectOne(where, "");
    }

    public Object selectOne(String where, String order_by) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        Collection col = this.select(where, order_by);
        if (col.isEmpty()) {
            throw new BeanQLResultEmptyException("\u691c\u7d22\u7d50\u679c 0\u4ef6");
        }
        if (col.size() > 1) {
            throw new BeanQLResultMultiException("\u691c\u7d22\u7d50\u679c " + col.size() + "\u4ef6");
        }
        Object o = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public void close() throws BeanQLException {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                throw new BeanQLException(e);
            }
        }
    }

    public static void closeSafe(BeanQLStatementIF st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (BeanQLException e) {
            e.printStackTrace();
        }
    }

    public int updateExclusive(Object o, String where) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException, BeanQLExclusiveException {
        return this.updateExclusive(o, where, "");
    }

    public int updateExclusive(Object o, String where, String exclusive_check_field) throws SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException, BeanQLExclusiveException {
        Object db_bean;
        this.validateBean(o);
        int pc = 0;
        StringBuffer where_sql = new StringBuffer();
        Iterator bpit = this.bpList.iterator();
        while (bpit.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit.next();
            if (!bp.getColumnProp().isPrimaryKey()) continue;
            if (pc > 0) {
                where_sql.append(",");
            }
            Object val = this.getValueByType(o, bp);
            where_sql.append(String.valueOf(bp.getName()) + " = " + BeanQLStatementSupport.formatVal(val));
        }
        if (where != null && where.trim().length() > 0) {
            where_sql.append(" AND " + where.trim());
        }
        if (exclusive_check_field != null && exclusive_check_field.length() > 0 && !this.equalFieldVal(db_bean = this.selectOne(String.valueOf(where_sql.toString()) + " FOR UPDATE"), o, exclusive_check_field)) {
            throw new BeanQLExclusiveException(String.valueOf(this.getTableName()) + "." + exclusive_check_field + " is not match in bean.");
        }
        StringBuffer sql = new StringBuffer("UPDATE " + this.getTableName() + " SET ");
        int c = 0;
        DBDependQLStatement dep = DBDependQLStatementFactory.create(this.super_tr.getConnection(), this.super_tr.mgr);
        Iterator bpit2 = this.bpList.iterator();
        while (bpit2.hasNext()) {
            BeanProperty bp = (BeanProperty)bpit2.next();
            if (bp.getColumnProp().isPrimaryKey()) continue;
            Object val = this.getValueByType(o, bp);
            if (c > 0) {
                sql.append(",");
            }
            if (bp.columnProp.getName().equalsIgnoreCase(exclusive_check_field)) {
                sql.append(String.valueOf(bp.getName()) + "=" + dep.getSQL_NOW());
            } else {
                sql.append(String.valueOf(bp.getName()) + "=" + BeanQLStatementSupport.formatVal(val, bp.columnProp.getTypeAsDB(), dep));
            }
            ++c;
        }
        if (c == 0) {
            throw new BeanQLException("don't get Column");
        }
        sql.append(" WHERE " + where_sql.toString());
        return this.statement.executeUpdate(sql.toString());
    }

    public int deleteExclusive(Object o, String where, String exclusive_check_field) throws BeanQLExclusiveException, SQLException, BeanQLException, BeanQLResultEmptyException, BeanQLResultMultiException {
        Object db_bean;
        this.validateBean(o);
        boolean pc = false;
        StringBuffer where_sql = new StringBuffer();
        BeanProperty[] pk_bps = this.getPrimaryKeyBeanProperty();
        int i = 0;
        while (i < pk_bps.length) {
            if (i > 0) {
                where_sql.append(" AND ");
            }
            where_sql.append(String.valueOf(pk_bps[i].getColumnProp().getName()) + " = " + BeanQLPreparedStatement.formatVal(this.getValueByType(o, pk_bps[i])));
            ++i;
        }
        if (where != null && where.trim().length() > 0) {
            where_sql.append(" AND " + where.trim());
        }
        if (exclusive_check_field != null && exclusive_check_field.length() > 0 && !this.equalFieldVal(db_bean = this.selectOne(String.valueOf(where_sql.toString()) + " FOR UPDATE"), o, exclusive_check_field)) {
            throw new BeanQLExclusiveException(String.valueOf(this.getTableName()) + "." + exclusive_check_field + " is not match in bean.");
        }
        StringBuffer sql = new StringBuffer("DELETE FROM " + this.getTableName() + " ");
        sql.append(" WHERE " + where_sql.toString());
        return this.statement.executeUpdate(sql.toString());
    }

    public int count() throws SQLException {
        return this.count(null);
    }

    public int count(String where) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS NUM FROM " + this.getTableName());
        if (where != null && where.trim().length() > 0) {
            sql.append(" WHERE " + where);
        }
        ResultSet result = this.statement.executeQuery(sql.toString());
        int num = 0;
        if (result.next()) {
            num = result.getInt("NUM");
        }
        result.close();
        return num;
    }
}

