/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.powerbeans.beanql.BeanProperty;
import jp.co.powerbeans.beanql.BeanQLStatementIF;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.BeanQLUtil;
import jp.co.powerbeans.beanql.CPCache;
import jp.co.powerbeans.beanql.ColumnProperty;
import jp.co.powerbeans.beanql.Log;
import jp.co.powerbeans.beanql.TypeMappings;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.exceptions.BeanQLNotExistResultException;
import jp.co.powerbeans.beanql.exceptions.BeanQLTableNotFoundException;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatement;
import org.apache.oro.text.perl.Perl5Util;

public abstract class BeanQLStatementSupport
implements BeanQLStatementIF {
    private static Perl5Util perl = new Perl5Util();
    private static final String EN_FORMT = "s!\\\\!\\\\\\\\!g";
    protected String tableName;
    protected Class bean;
    protected ArrayList bpList;
    protected BeanQLTransaction super_tr;
    protected static Map beanMap = new HashMap();
    protected static final Class[] RS_METHOD_PARAM;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        RS_METHOD_PARAM = classArray;
    }

    public static String formatVal(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof String) {
            return "'" + perl.substitute(EN_FORMT, o.toString()) + "'";
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(o)) {
            return "'" + BeanQLUtil.formatDate((Date)o) + "'";
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isInstance(o)) {
            return "'" + BeanQLUtil.formatDate(((Calendar)o).getTime()) + "'";
        }
        if (o instanceof byte[]) {
            return "'" + new String((byte[])o) + "'";
        }
        return o.toString();
    }

    public static String formatVal(Object o, String column_type, DBDependQLStatement dep) {
        if (o == null) {
            if (column_type.equalsIgnoreCase("TIMESTAMP")) {
                return dep.getSQL_NOW("TIMESTAMP");
            }
            return "NULL";
        }
        if (o instanceof String) {
            return "'" + perl.substitute(EN_FORMT, o.toString()) + "'";
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(o)) {
            return dep.formatDateVal((Date)o, column_type);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isInstance(o)) {
            Date date = ((Calendar)o).getTime();
            return dep.formatDateVal(date, column_type);
        }
        if (o instanceof byte[]) {
            return "'" + new String((byte[])o) + "'";
        }
        return o.toString();
    }

    protected void createSQLMapping() throws BeanQLException, SQLException, BeanQLTableNotFoundException {
        this.bpList = BeanQLStatementSupport.getBeanPropertyList(this.bean, this.super_tr);
    }

    static final ArrayList getBeanPropertyList(Class bean, BeanQLTransaction super_tr) throws SQLException, BeanQLException {
        if (beanMap.containsKey(bean.getName())) {
            return (ArrayList)beanMap.get(bean.getName());
        }
        String table = BeanQLUtil.className2TableName(bean);
        ArrayList cp_list = CPCache.getColumnPropertyList(super_tr.getConnection(), super_tr.mgr, table);
        if (cp_list.size() == 0) {
            throw new BeanQLTableNotFoundException("cannot get table(" + table + " for bean:" + bean.getName());
        }
        try {
            ArrayList<BeanProperty> bp_list = new ArrayList<BeanProperty>(cp_list.size());
            BeanInfo info = Introspector.getBeanInfo(bean);
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> prop_map = new HashMap<String, PropertyDescriptor>(properties.length);
            int i = 0;
            while (i < properties.length) {
                prop_map.put(properties[i].getName().toUpperCase(), properties[i]);
                ++i;
            }
            Iterator cit = cp_list.iterator();
            while (cit.hasNext()) {
                ColumnProperty cp = (ColumnProperty)cit.next();
                if (!prop_map.containsKey(cp.getName().toUpperCase())) continue;
                PropertyDescriptor p = (PropertyDescriptor)prop_map.get(cp.getName().toUpperCase());
                Class<?> type = p.getPropertyType();
                String name = p.getName();
                Method m_get = p.getReadMethod();
                Method m_set = p.getWriteMethod();
                BeanProperty bp = new BeanProperty(type, name, m_get, m_set);
                bp.setColumnProp(cp);
                bp_list.add(bp);
            }
            beanMap.put(bean.getName(), bp_list);
            prop_map = null;
            return bp_list;
        }
        catch (IntrospectionException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanProperty[] getPrimaryKeyBeanProperty() {
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>(1);
        Iterator it = this.bpList.iterator();
        while (it.hasNext()) {
            BeanProperty bp = (BeanProperty)it.next();
            if (!bp.getColumnProp().isPrimaryKey()) continue;
            list.add(bp);
        }
        return list.toArray(new BeanProperty[0]);
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected Object getValueByType(ResultSet result, BeanProperty bp) throws BeanQLException, BeanQLNotExistResultException {
        String get_method = (String)TypeMappings.java2ResultsetGetter.get(bp.getType().getName());
        if (get_method == null) {
            Log.println("getValueByType not support type:" + bp.getType().getName());
            return null;
        }
        try {
            Class<?> clazz;
            Method method = null;
            if (bp.getType().getName().equals("java.util.Date")) {
                String type_as_db = bp.getColumnProp().getTypeAsDB().toUpperCase();
                if (type_as_db.startsWith("TIMESTAMP") || type_as_db.startsWith("DATETIME")) {
                    get_method = "getTimestamp";
                } else if (type_as_db.startsWith("TIME")) {
                    get_method = "getTime";
                } else if (type_as_db.equals("DATE")) {
                    get_method = "getDate";
                }
            }
            if ((clazz = class$3) == null) {
                try {
                    clazz = class$3 = Class.forName("java.sql.ResultSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method = clazz.getDeclaredMethod(get_method, RS_METHOD_PARAM);
            return method.invoke((Object)result, (Object[])new String[]{bp.getName()});
        }
        catch (InvocationTargetException e) {
            throw new BeanQLNotExistResultException(e);
        }
        catch (Exception e) {
            throw new BeanQLException(e);
        }
    }

    protected Object getBeanByResultSet(ResultSet result) throws BeanQLException {
        try {
            Object o = Class.forName(this.bean.getName()).newInstance();
            Iterator bpit = this.bpList.iterator();
            while (bpit.hasNext()) {
                BeanProperty bp = (BeanProperty)bpit.next();
                try {
                    Object val = this.getValueByType(result, bp);
                    Log.debug("setting " + bp.getM_set() + "(" + bp.getColumnProp().getName());
                    bp.getM_set().invoke(o, val);
                }
                catch (BeanQLNotExistResultException e) {
                    e.printStackTrace();
                }
            }
            return o;
        }
        catch (Exception e) {
            throw new BeanQLException(e);
        }
    }

    protected boolean equalFieldVal(Object o1, Object o2, String field) throws BeanQLException {
        Iterator it = this.bpList.iterator();
        while (it.hasNext()) {
            BeanProperty bp = (BeanProperty)it.next();
            if (!bp.columnProp.getName().equalsIgnoreCase(field)) continue;
            Object v1 = this.getValueByType(o1, bp);
            Object v2 = this.getValueByType(o2, bp);
            if (v1 == null || v2 == null) {
                return v1 == null && v2 == null;
            }
            return v1.equals(v2);
        }
        return false;
    }

    protected Object getValueByType(Object o, BeanProperty bp) throws BeanQLException {
        Method method = bp.getM_get();
        if (method == null) {
            throw new BeanQLException("not implement type:" + bp.getName());
        }
        try {
            return method.invoke(o, null);
        }
        catch (Exception e) {
            throw new BeanQLException(e.getMessage(), e);
        }
    }

    protected void validateBean(Object o) throws BeanQLException {
        if (o == null) {
            throw new BeanQLException("object is null.");
        }
        if (!this.bean.isInstance(o)) {
            throw new BeanQLException("object is not instanceof " + this.bean);
        }
    }
}

