/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import jp.co.powerbeans.beanql.BeanProperty;
import jp.co.powerbeans.beanql.BeanQLManager;
import jp.co.powerbeans.beanql.BeanQLPreparedStatement;
import jp.co.powerbeans.beanql.BeanQLSimpleViewStatement;
import jp.co.powerbeans.beanql.BeanQLStatement;
import jp.co.powerbeans.beanql.BeanQLStatementSupport;
import jp.co.powerbeans.beanql.BeanQLUtil;
import jp.co.powerbeans.beanql.BeanQLViewPreparedStatement;
import jp.co.powerbeans.beanql.Log;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.exceptions.BeanQLTableNotFoundException;

public class BeanQLTransaction {
    private Connection connection;
    BeanQLManager mgr;

    BeanQLTransaction(Connection con, BeanQLManager mgr) throws BeanQLException {
        if (con == null) {
            throw new BeanQLException("Connection is null.");
        }
        this.setConnection(con);
        this.mgr = mgr;
    }

    void setConnection(Connection con) {
        this.connection = con;
    }

    public void setAutoCommit(boolean b) throws BeanQLException {
        try {
            this.connection.setAutoCommit(b);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public void close() throws BeanQLException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                Log.println("closed.");
            }
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLStatement createStatement(Class bean_class) throws BeanQLException, BeanQLTableNotFoundException {
        try {
            return new BeanQLStatement(bean_class, this.connection.createStatement(), this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLStatement createStatement(String bean_class_name) throws BeanQLException, BeanQLTableNotFoundException {
        Class<?> bean_class;
        try {
            bean_class = Class.forName(bean_class_name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BeanQLException("cannot create class :" + bean_class_name, e);
        }
        return this.createStatement(bean_class);
    }

    public void commit() throws BeanQLException {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public void rollback() throws BeanQLException {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public BeanQLSimpleViewStatement createSimpleViewStatement(Class bean_class) throws BeanQLException {
        try {
            return new BeanQLSimpleViewStatement(bean_class, this.connection.createStatement(), this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLPreparedStatement createPreparedStatement(Class bean_class, String sql) throws BeanQLTableNotFoundException, BeanQLException {
        try {
            return new BeanQLPreparedStatement(bean_class, this.connection.prepareStatement(sql), this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLPreparedStatement createPreparedStatement(String bean_class_name, String sql) throws BeanQLTableNotFoundException, BeanQLException {
        Class<?> bean_class;
        try {
            bean_class = Class.forName(bean_class_name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BeanQLException("cannot create class :" + bean_class_name, e);
        }
        return this.createPreparedStatement(bean_class, sql);
    }

    public BeanQLViewPreparedStatement createViewPreparedStatement(Class bean_class, String sql) throws BeanQLException {
        try {
            return new BeanQLViewPreparedStatement(bean_class, this.connection.prepareStatement(sql));
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLViewPreparedStatement createViewPreparedStatement(String bean_class_name, String sql) throws BeanQLException {
        Class<?> bean_class;
        try {
            bean_class = Class.forName(bean_class_name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BeanQLException("cannot create class :" + bean_class_name, e);
        }
        return this.createViewPreparedStatement(bean_class, sql);
    }

    public BeanQLPreparedStatement createPreparedStatement_forInsert(Class bean_class) throws BeanQLTableNotFoundException, BeanQLException {
        StringBuffer sql = new StringBuffer();
        try {
            ArrayList bpList = BeanQLStatementSupport.getBeanPropertyList(bean_class, this);
            sql.append("INSERT INTO " + BeanQLUtil.className2TableName(bean_class) + " ( ");
            int c = 0;
            Iterator bpit = bpList.iterator();
            while (bpit.hasNext()) {
                BeanProperty bp = (BeanProperty)bpit.next();
                if (bp.getColumnProp().isNotUseInsertSql()) continue;
                if (c++ > 0) {
                    sql.append(",");
                }
                sql.append(bp.getColumnProp().getName());
            }
            sql.append(") VALUES (");
            int i = 0;
            while (i < c) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                ++i;
            }
            sql.append(")");
            return this.createPreparedStatement(bean_class, sql.toString());
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLPreparedStatement createPreparedStatement_forUpdate(Class bean_class) throws BeanQLException {
        return this.createPreparedStatement_forUpdate(bean_class, null);
    }

    public BeanQLPreparedStatement createPreparedStatement_forUpdate(Class bean_class, String where) throws BeanQLException {
        StringBuffer sql = new StringBuffer();
        try {
            ArrayList bpList = BeanQLStatementSupport.getBeanPropertyList(bean_class, this);
            sql.append("UPDATE " + BeanQLUtil.className2TableName(bean_class) + " SET ");
            int c = 0;
            Iterator bpit = bpList.iterator();
            while (bpit.hasNext()) {
                BeanProperty bp = (BeanProperty)bpit.next();
                if (bp.getColumnProp().isNotUseInsertSql()) continue;
                if (c++ > 0) {
                    sql.append(",");
                }
                sql.append(bp.getColumnProp().getName());
                sql.append("=?");
            }
            String where_sql = "";
            if (where != null && where.trim().length() > 0) {
                sql.append(" WHERE " + where);
                where_sql = where;
            } else {
                sql.append(" WHERE ");
                StringBuffer where_sqlw = new StringBuffer();
                c = 0;
                Iterator bpit2 = bpList.iterator();
                while (bpit2.hasNext()) {
                    BeanProperty bp = (BeanProperty)bpit2.next();
                    if (!bp.columnProp.isPrimaryKey()) continue;
                    if (c++ > 0) {
                        where_sqlw.append(" AND ");
                    }
                    where_sqlw.append(String.valueOf(bp.columnProp.getName()) + "=?");
                }
                where_sql = where_sqlw.toString();
                sql.append(where_sql);
            }
            return this.createPreparedStatement(bean_class, sql.toString(), where_sql);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }

    public BeanQLPreparedStatement createPreparedStatement(Class bean_class, String sql, String where_sql) throws BeanQLException {
        try {
            return new BeanQLPreparedStatement(bean_class, this.connection.prepareStatement(sql), where_sql, this);
        }
        catch (SQLException e) {
            throw new BeanQLException(e);
        }
    }
}

