/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class BeanQLUtil {
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Integer[] static_integer = new Integer[256];

    static {
        int i = 0;
        while (i < static_integer.length) {
            BeanQLUtil.static_integer[i] = new Integer(i);
            ++i;
        }
    }

    private BeanQLUtil() {
    }

    public static String className2TableName(Class bean) {
        int last_dot = bean.getName().lastIndexOf(46);
        if (last_dot == -1) {
            return bean.getName();
        }
        return bean.getName().substring(last_dot + 1);
    }

    public static String formatDate(Date date) {
        return df.format(date);
    }

    public static String formatTime(Date date) {
        return tf.format(date);
    }

    public static String formatDateTime(Date date) {
        return dtf.format(date);
    }

    public static Integer getInteger(int i) {
        try {
            return static_integer[i];
        }
        catch (RuntimeException e) {
            return static_integer[0];
        }
    }
}

