/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.powerbeans.beanql.BeanProperty;
import jp.co.powerbeans.beanql.BeanQLStatementIF;
import jp.co.powerbeans.beanql.Log;
import jp.co.powerbeans.beanql.TypeMappings;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;

public abstract class BeanQLViewStatementSupport
implements BeanQLStatementIF {
    protected static final Class[] RS_METHOD_PARAM;
    protected Class bean;
    protected ArrayList bpList;
    protected static Map beanMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        RS_METHOD_PARAM = classArray;
        beanMap = new HashMap();
    }

    protected void createBeanFieldListMap() throws BeanQLException {
        if (beanMap.containsKey(this.bean.getName())) {
            this.bpList = (ArrayList)beanMap.get(this.bean.getName());
            return;
        }
        try {
            ArrayList<BeanProperty> bp_list = new ArrayList<BeanProperty>();
            BeanInfo info = Introspector.getBeanInfo(this.bean);
            PropertyDescriptor[] p = info.getPropertyDescriptors();
            int i = 0;
            while (i < p.length) {
                Class<?> type = p[i].getPropertyType();
                String name = p[i].getName();
                Method m_get = p[i].getReadMethod();
                Method m_set = p[i].getWriteMethod();
                if (m_set != null && m_get != null) {
                    BeanProperty bp = new BeanProperty(type, name, m_get, m_set);
                    bp_list.add(bp);
                }
                ++i;
            }
            beanMap.put(this.bean.getName(), bp_list);
            this.bpList = bp_list;
        }
        catch (IntrospectionException e) {
            throw new BeanQLException(e);
        }
    }

    protected Object getBeanByResultSet(ResultSet result) throws BeanQLException {
        try {
            Object o = Class.forName(this.bean.getName()).newInstance();
            Iterator bpit = this.bpList.iterator();
            while (bpit.hasNext()) {
                BeanProperty bp = (BeanProperty)bpit.next();
                Object val = this.getValueByType(result, bp);
                bp.getM_set().invoke(o, val);
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BeanQLException(e);
        }
    }

    protected Object getValueByType(ResultSet result, BeanProperty bp) throws BeanQLException {
        String get_method = (String)TypeMappings.java2ResultsetGetter.get(bp.getType().getName());
        if (get_method == null) {
            Log.println("BeanQLSimpleViewStatement not implement type [" + bp.getType().getName() + "]");
            return null;
        }
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.ResultSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method method = clazz.getDeclaredMethod(get_method, RS_METHOD_PARAM);
            return method.invoke((Object)result, (Object[])new String[]{bp.getName()});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BeanQLException(e);
        }
    }
}

