/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import jp.co.powerbeans.beanql.BeanQLManager;
import jp.co.powerbeans.beanql.Log;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatement;
import jp.co.powerbeans.beanql.vendor.DBDependQLStatementFactory;

public final class CPCache {
    private static final HashMap cpMap = new HashMap();

    private CPCache() {
    }

    public static boolean contains(String bean_name) {
        return cpMap.containsKey(bean_name);
    }

    public static ArrayList get(String bean_name) {
        return (ArrayList)cpMap.get(bean_name);
    }

    public static void put(String bean_name, ArrayList bp_list) {
        cpMap.put(bean_name, bp_list);
    }

    public static ArrayList getColumnPropertyList(Connection connection, BeanQLManager mgr, String tableName) throws SQLException, BeanQLException {
        if (!cpMap.containsKey(tableName)) {
            DBDependQLStatement dqs = DBDependQLStatementFactory.create(connection, mgr);
            cpMap.put(tableName, dqs.getColumnPropertyList(tableName));
            Log.println("ADD CPCACHE:" + tableName + "  CacheSize:" + cpMap.size());
        }
        return (ArrayList)cpMap.get(tableName);
    }
}

