/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql.dao;

import jp.co.powerbeans.beanql.BeanQLManager;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.dao.BeanQLCoreDAO;
import jp.co.powerbeans.beanql.dao.BeanQLDAO;
import jp.co.powerbeans.beanql.exceptions.BeanQLException;

public abstract class BeanQLBaseDAO
extends BeanQLCoreDAO
implements BeanQLDAO {
    private BeanQLTransaction bqlTrn;
    private String exclusiveCheckField;
    private boolean singleCallMethod = true;

    public BeanQLBaseDAO(BeanQLManager manager, Class bean_class) {
        super(manager, bean_class);
        this.setReturnNull(true);
    }

    protected BeanQLTransaction getBeanQLTransaction() throws BeanQLException {
        if (this.singleCallMethod) {
            this.close(this.bqlTrn);
            this.bqlTrn = this.getManager().getBeanQLTransaction();
            this.bqlTrn.setAutoCommit(true);
        } else if (this.bqlTrn == null) {
            this.bqlTrn = this.getManager().getBeanQLTransaction();
            this.bqlTrn.setAutoCommit(false);
        }
        return this.bqlTrn;
    }

    protected void finalize() throws Throwable {
        this.close(this.bqlTrn);
        super.finalize();
    }

    public String getExclusiveCheckField() {
        return this.exclusiveCheckField;
    }

    public void commit() {
        if (this.singleCallMethod) {
            try {
                this.bqlTrn.commit();
            }
            catch (BeanQLException e) {
                this.onException(e);
            }
        }
    }

    public void setSingleCallMethod(boolean singleCallMethod) {
        if (this.bqlTrn != null) {
            throw new IllegalStateException("BeanQL can't change singleCallMethod while Transaction exist.");
        }
        this.singleCallMethod = singleCallMethod;
    }

    public void close() {
        this.close(this.bqlTrn);
    }

    public void commitAndClose() {
        this.commit();
        this.close();
    }

    public void rollback() {
        this.rollback(this.bqlTrn);
    }

    protected void rollback(BeanQLTransaction bqlTrn2) {
        try {
            if (bqlTrn2 != null && bqlTrn2.getConnection() != null && !bqlTrn2.getConnection().isClosed()) {
                bqlTrn2.rollback();
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    public void setExclusiveCheckField(String exclusiveCheckField) {
        this.exclusiveCheckField = exclusiveCheckField;
    }

    public boolean isSingleCallMethod() {
        return this.singleCallMethod;
    }
}

