/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.beanql.dao;

import jp.co.powerbeans.beanql.BeanQLManager;
import jp.co.powerbeans.beanql.BeanQLTransaction;
import jp.co.powerbeans.beanql.exceptions.BeanQLExceptionListener;

abstract class BeanQLCoreDAO {
    private BeanQLManager manager;
    private final Class beanClass;
    private boolean returnNull;
    private boolean throwException;
    private BeanQLExceptionListener exceptionListener;

    public BeanQLCoreDAO(BeanQLManager manager, Class bean_class) {
        this.manager = manager;
        this.beanClass = bean_class;
        this.exceptionListener = manager.getExceptionListener();
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public BeanQLManager getManager() {
        return this.manager;
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    protected void onException(Exception e) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(e);
        }
        if (this.throwException) {
            throw new RuntimeException(e);
        }
    }

    public void setThrowException(boolean throw_exception) {
        this.throwException = throw_exception;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    protected Object createBean() {
        try {
            return this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Object createSafeBean() {
        if (this.returnNull) {
            return null;
        }
        try {
            return this.beanClass.newInstance();
        }
        catch (Exception e) {
            this.onException(e);
            return null;
        }
    }

    protected void close(BeanQLTransaction bqlTrn) {
        try {
            if (bqlTrn != null && bqlTrn.getConnection() != null && !bqlTrn.getConnection().isClosed()) {
                bqlTrn.close();
            }
            if (bqlTrn != null) {
                bqlTrn = null;
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    public BeanQLExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(BeanQLExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }
}

