package jp.co.powerbeans.docbuild;


import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

public class HTMLBuilderTest extends TestCase {

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * 'jp.co.powerbeans.docbuild.HTMLBuilder.output(String, Object)' のためのテスト・メソッド
	 */
	public void testOutput1File() {
		String template = "template/test.html";
		PBDocumentBuilder builder = PBDocmentBuilderFactory.create(
				PBDocumentBuilder.HTML,	template,"Shift_JIS");
		
		// 値格納
		// key,value
		builder.assign("name", "なめえ");
		
		// Single bean
		TestBean bean = new TestBean();
		bean.setName("ビーン名");
		builder.assign(bean);
		
		// List bean
		builder.assign("names", getTestBeanList());
		
		// List の List
		builder.assign("outlist", getTestOutList());
		
		// 出力
		builder.output("C:/html/test.html");
		
		
		try {
			File file = new File("C:/html/test.html");
			Runtime.getRuntime().exec("explorer " + file.getPath());
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}

//	/*
//	 * 'jp.co.powerbeans.docbuild.HTMLBuilder.output(String, Object)' のためのテスト・メソッド
//	 */
//	public void testOutputAllFile() {
//		String template = "template/";
//		PBDocumentBuilder builder = PBDocmentBuilderFactory.create(
//				PBDocumentBuilder.HTML,	template);
//		
//		// 値格納
//		// key,value
//		builder.assign("name", "なめえ");
//		
//		// Single bean
//		TestBean bean = new TestBean();
//		bean.setName("ビーン名");
//		builder.assign(bean);
//		
//		// List bean
//		builder.assign("names", getTestBeanList());
//		
//		// 出力
//		builder.output("C:/html/test.html");
//	}
	
	/**
	 * ListのListを返す
	 * @return
	 */
	private List getTestOutList() {
		List outlist = new ArrayList();
		for (int i = 0; i < 3; i++) {
			TestHasListBean list1 = new TestHasListBean();
			list1.setList(getTestBeanList());
			outlist.add(list1);
		}
		
		return outlist;
	}

	private List getTestBeanList() {
		List list = new ArrayList();
		for (int i = 0; i < 2; i++) {
			TestBean bean = new TestBean();
			bean.setName("リストbean名" + i);
			bean.setOld("" + (10 + i));
			list.add(bean);
		}
		
		return list;
	}

}
