package jp.co.powerbeans.docbuild;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;

public abstract class PBDocumentBuilderBase implements PBDocumentBuilder {

	protected String templatePath;
	private String templateDir;

	private Map assignedValMap;

	private Map assignedListMap;

	private Map innerValMap;

	protected Object[] tokens;

	private List includeFileList;

	// private boolean isDirectory;
	// private boolean isFile;

	public PBDocumentBuilderBase(String template_path) {
		this.templatePath = template_path;
		this.assignedValMap = new HashMap();
		this.innerValMap = new HashMap();
		this.assignedListMap = new HashMap();
		this.includeFileList = new ArrayList();
		
		File template_file = new File(template_path);
		this.templateDir = template_file.getParent();

		// // 1, templatePath がDirかファイルか判定
		// {
		// File f = new File(templatePath);
		// this.isDirectory = f.isDirectory();
		// this.isFile = f.isFile();
		// }

		// 1. テンプレートファイルを開いてクラスで取得
		tokens = perseTemplate();
	}

	protected Object[] perseTemplate() {
		List<Object> res = new ArrayList<Object>();
		LineNumberReader lin = null;

		try {
			lin = new LineNumberReader(new FileReader(templatePath));
			String line = null;
			StringBuffer tmp = new StringBuffer();
			while ((line = lin.readLine()) != null) {
				tmp.append(line);
			}

			// 解析開始
			res.addAll(Arrays.asList(SmartyParser.parseTags(tmp.toString(),
					this)));

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (lin != null) {
				try {
					lin.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

		return (Object[]) res.toArray(new Object[res.size()]);
	}

	public void assign(String key, String value) {
		this.assignedValMap.put(key, value);
	}

	public void assign(String key, Object[] objs) {
		this.assignedListMap.put(key, Arrays.asList(objs));
	}

	public void assign(String key, Collection col) {
		// そのままassignedListMapに格納する
		this.assignedListMap.put(key, col);

		// // 各プロパティの配列として格納する
		// int c = 0;
		// for (Iterator it = col.iterator(); it.hasNext(); c++) {
		// Object bean = (Object) it.next();
		// try {
		// Map valmap = BeanUtils.describe(bean);
		// for (Iterator it1 = valmap.keySet().iterator(); it1.hasNext();) {
		// Object mkey = it1.next();
		// String mapkey = key + "." + (String) mkey;
		// List list = null;
		// if (c == 0) {
		// list = new ArrayList();
		// this.assignedListMap.put(mapkey, list);
		// } else {
		// list = (List) this.assignedListMap.get(mapkey);
		// }
		//					
		// list.add(valmap.get(mkey));
		// }
		//				
		// } catch (Exception e) {
		// e.printStackTrace();
		// }
		// }
	}

	public void assign(Object bean) {

		// 1. クラス名取得
		String class_name = bean.getClass().getName().substring(
				bean.getClass().getPackage().getName().length()).replaceFirst(
				"\\.", "");

		// 2. beanのクラス名.プロパティ名 をキーとして各値を格納
		try {
			Map valmap = BeanUtils.describe(bean);
			for (Iterator it = valmap.keySet().iterator(); it.hasNext();) {
				String key = (String) it.next();
				this.assignedValMap
						.put(class_name + "." + key, valmap.get(key));
			}

		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		}

	}

	public Map getAssignedValMap() {
		return assignedValMap;
	}

	public Map getInnerValMap() {
		return innerValMap;
	}

	public Map getAssignedListMap() {
		return assignedListMap;
	}

	public void addIncludeFile(String include_file) {
		this.includeFileList.add(this.templateDir + File.separator + include_file);
//		this.includeFileList.add(this.templatePath + include_file);
	}

	public void output(String out_file) {
		// コピー先フォルダを取得
		File outfile = new File(out_file);
		File outdir = outfile.getParentFile();

		try {
			if (!outdir.exists()) {
				outdir.mkdirs();
			}

			// include ファイルを全てコピー
			for (Iterator iter = this.includeFileList.iterator(); iter
					.hasNext();) {
				String include_file = (String) iter.next();
				FileCopy.copy(include_file, outdir.getCanonicalPath());
			}
		} catch (IOException e) {
			e.printStackTrace();
			Log.debug(e.getMessage());
			return;
		}
	}

}
