package jp.co.powerbeans.docbuild;

import java.util.HashMap;
import java.util.Map;

import jp.co.powerbeans.docbuild.exp.Exp;

public class SmartyAttr {

	private Map<String, String> attrmap;
	private String name;
	private int startTagLeft;
	private int startTagRight;
	private int endTagLeft;
	private int endTagRight;

	public SmartyAttr(String exporg, int left, int right) {
		this(exporg, left, right, false);
	}

	public SmartyAttr(String exporg, int left, int right, boolean var_flg) {
		this.attrmap = new HashMap<String, String>();
		this.startTagLeft = left;
		this.startTagRight = right;
		if (var_flg) {
			this.name = Exp.VAR_FR;
			return;
		}
		
		String exp = exporg.replaceFirst("^\\{", "").replaceFirst("\\}$","");
		String[] items = exp.split(" ");
		this.name = items[0];

		for (int i = 1; i < items.length; i++) {
			String[] ex = items[i].split("=");
			if (ex.length == 2) {
				attrmap.put(ex[0], ex[1].replaceAll("\"",""));
			}
		}
	}

	public String get(String attribute) {
		return (String) attrmap.get(attribute);
	}

	public String getName() {
		return name;
	}

	public int getStartTagLeft() {
		return startTagLeft;
	}

	public int getStartTagRight() {
		return startTagRight;
	}

	public int getEndTagLeft() {
		return endTagLeft;
	}

	public void setEndTagLeft(int endTagLeft) {
		this.endTagLeft = endTagLeft;
	}

	public int getEndTagRight() {
		return endTagRight;
	}

	public void setEndTagRight(int endTagRight) {
		this.endTagRight = endTagRight;
	}

}
