package jp.co.powerbeans.docbuild.exp;

import jp.co.powerbeans.docbuild.Log;
import jp.co.powerbeans.docbuild.PBDocumentBuilder;
import jp.co.powerbeans.docbuild.SmartyAttr;

public class VarExp implements SmartyExp {

	private PBDocumentBuilder builder;
	private String key;
	private String subhtml;
	
	public void parse(PBDocumentBuilder builder, SmartyAttr parser, String subhtml) {
		this.builder = builder;
		this.subhtml = subhtml;
		String var = subhtml.substring(2, subhtml.length() - 1);
		// var に.が存在する場合はBean or リストの変数とする
		if (var.indexOf(".") != -1) {
			String[] ps = var.split("\\.");
			key = ps[0] + "." + ps[1];
		} else {
			key = var;
		}
	}
	
	public String getOutputString() {
		if (this.builder.getAssignedValMap().containsKey(key)) {
			// 全体Mapに存在する場合、その値を返す
			String val = (String) this.builder.getAssignedValMap().get(key);
			Log.debug(" output label:" + subhtml + " value:" + val);
			return val;
			
		} else if (this.builder.getInnerValMap().containsKey(key)) {
			// 入れ子用Mapに存在する場合、その値を返す
			String val = (String) this.builder.getInnerValMap().get(key);
			Log.debug(" output inner:" + subhtml + " value:" + val);
			return val;
			
		} else {
			Log.debug(" warning!! output label:" + subhtml + " value:(not assigned)");
			return this.subhtml;
		}
	}	


}
