/*!
  \file
  \brief ʐM̋L^

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionLogger.h"
#include "TcpipCtrl.h"
#include <string>
#include <fstream>


struct ConnectionLogger::pImpl {
  ConnectionInterface* com;
  std::string base_name;
  std::fstream fd_recv;
  std::fstream fd_send;

  pImpl(ConnectionInterface* com_obj) : com(com_obj), base_name("tcpipLog") {
    if (com == NULL) {
      // !!! LogManager
      throw;
    }
  }

  ~pImpl(void) {
    terminate();
    delete com;
  }

  void open(void) {
    if (! fd_recv.is_open()) {
      std::string recv_file = base_name + "_recv.txt";
      fd_recv.open(recv_file.c_str(), std::ios::out | std::ios::binary);

      std::string send_file = base_name + "_send.txt";
      fd_send.open(send_file.c_str(), std::ios::out | std::ios::binary);
    }
  }

  void terminate(void) {
    if (fd_recv.is_open()) {
      fd_recv.close();
      fd_send.close();
    }
  }
};


ConnectionLogger::ConnectionLogger(ConnectionInterface* com)
  : pimpl(new pImpl(com)) {
}


ConnectionLogger::~ConnectionLogger(void) {
}


const char* ConnectionLogger::what(void) {
  return pimpl->com->what();
}


int ConnectionLogger::connect(const char* host, long port) {

  pimpl->open();
  return pimpl->com->connect(host, port);
}


void ConnectionLogger::disconnect(void) {
  pimpl->com->disconnect();
}


bool ConnectionLogger::isConnected(void) {
  return pimpl->com->isConnected();
}


int ConnectionLogger::changeBaudrate(long baudrate) {
  return pimpl->com->changeBaudrate(baudrate);
}


int ConnectionLogger::send(const char* data, int size) {

  if (size > 0) {
    // data ̓et@Cɏo
    pimpl->fd_send.write(data, size);
    pimpl->fd_send.flush();
  }
  return pimpl->com->send(data, size);
}


int ConnectionLogger::recv(char* data, int size, int timeout) {

  int n = pimpl->com->recv(data, size, timeout);

  if (n > 0) {
    // data ̓et@Cɏo
    pimpl->fd_recv.write(data, n);
    pimpl->fd_recv.flush();
  }
  return n;
}


int ConnectionLogger::size(void) {
  return pimpl->com->size();
}


void ConnectionLogger::clear(void) {
  return pimpl->com->clear();
}


void ConnectionLogger::setLogfileName(const char* logfileName) {
  pimpl->base_name = logfileName;
}


void ConnectionLogger::skip(int timeout) {
  clear();

  char buffer[BUFSIZ];
  int total = 0;
  int n;

  enum { EachTimeout = 10 };
  do {
    n = recv(buffer, BUFSIZ, EachTimeout);
    total += EachTimeout;
  } while ((n > 0) && ((timeout > 0) && (total < timeout)));
}
