#ifndef TCPIP_CTRL_H
#define TCPIP_CTRL_H

/*!
  \file
  \brief TCP/IP ڑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionInterface.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
#include <SDL_net.h>
#else
class TCPsocket {
public:
  TCPsocket(void *dummy) {
  }
};

class SDLNet_SocketSet {
public:
  SDLNet_SocketSet(void *dummy) {
  }
};

class IPaddress {
};
#endif
#include <memory>

class SocketSet;


/*!
  \brief TCP/IP ڑnh
*/
class TcpipCtrl : public ConnectionInterface {
  TcpipCtrl(const TcpipCtrl& rhs);
  TcpipCtrl& operator = (const TcpipCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  enum { NoTimeout = -1 };
  TcpipCtrl(void);
  explicit TcpipCtrl(SocketSet* socketSet, TCPsocket socket = NULL);
  ~TcpipCtrl(void);

  const char* what(void);
  int connect(const char* host, long port);
  void disconnect(void);
  bool isConnected(void);
  int changeBaudrate(long baudrate);
  int send(const char* data, int size);
  int recv(char* data, int size, int timeout);
  int size(void);
  void clear(void);
  void skip(int timeout);

  TCPsocket getNetSocket(void);
};

#endif /* !TCPIP_CTRL_H */
