#ifndef CONNECTION_DEVICE_SEARCH_H
#define CONNECTION_DEVICE_SEARCH_H

/*!
  \file
  \brief iԍɂڑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class ConnectionInterface;
class ProductIdHandler;


class ConnectionDeviceSearch {
  ConnectionDeviceSearch(const ConnectionDeviceSearch& rhs);
  ConnectionDeviceSearch& operator = (const ConnectionDeviceSearch& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  ConnectionDeviceSearch(void);
  ~ConnectionDeviceSearch(void);

  void add(const char* device);
  void remove(const char* device);
  bool search(const char*& device, const char* productId,
	      const ProductIdHandler* handler);
};

#endif /* !CONNECTION_DEVICE_SEARCH_H */
