/*!
  \example
  \brief o[W̕\Tv

  \author Satofumi KAMIMURA

  $Id$

  usage:
  ./(this program) --urg_port=(COM Port)
*/

#include "UrgCtrl.h"
#include <SDL.h>

using namespace beego;


int main(int argc, char *argv[]) {

  UrgCtrl urg;
  if (! urg.connect(argc, argv)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  std::vector<std::string> lines;
  if (! urg.getVersionInfo(lines)) {
    printf("UrgCtrl::getVersionInfo: %s\n", urg.what());
    exit(1);
  }

  for (std::vector<std::string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    printf("%s\n", it->c_str());
  }

  return 0;
}
