<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		ViewRender.class.php
 * @brief		ビューレンダリングクラス
 * @date		2007.01.22
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class ViewRender extends PageRender
{
	function ViewRender()
	{
		$this->PageRender();
	}
	
	function renderView()
	{
		$this->display($this->template);
	}
	
	function renderRSSView()
	{
		header("Content-Type: text/xml; charset=UTF-8");
		echo $this->fetch($this->template);
		exit;
	}
	
	function renderError($error)
	{
		header("Location: ".CURRENT_HTTP_SERVER.MANAGER."/common/not-found.php");
		exit;
	}
	
	function assignBitcubeTags($group_code="",$category_code="",$entry_code="")
	{
		if($group_code)
			$this->assignGroupTags($group_code);
		if($category_code)
			$this->assignCurrentCategoryTags($category_code);
		if($entry_code)
			$this->assignCurrentEntryTags($entry_code);
	}
	
	function assignGroupTags($group_code)
	{
		$dao = new GroupManager();
		$this->group = $dao->getGroupInfo($group_code);
		
		if($this->group)
		{
			$this->group["rss_existence"] = (($this->group["group_rss1_output"] == 1) || ($this->group["group_rss2_output"] == 1) || ($this->group["group_atom_output"] == 1)) ? 1: 0;
			
			$this->assign('BCDomainRoot',CURRENT_HTTP_SERVER);
			$this->assign('BCSetID',$this->group["group_code"]);
			$this->assign('BCSetName',$this->group["group_name"]);
			$this->assign('BCSetURL',CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/");
			$this->assign('BCSetUploadURL',CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/".$this->group["group_upload_dir_name"]."/");
			$this->assign('BCSetDescription',$this->group["group_meta_description"]);
			$this->assign('BCSetKeyword',$this->group["group_meta_keyword"]);
			$this->assign('BCRssExistence',$this->group["rss_existence"]);
			$this->assign('BCRss1Output',$this->group["group_rss1_output"]);
			$this->assign('BCRss2Output',$this->group["group_rss2_output"]);
			$this->assign('BCRssAtomOutput',$this->group["group_atom_output"]);
			$this->assign('BCRss1URL',CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/".$this->group["group_rss1_file_name"]);
			$this->assign('BCRss2URL',CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/".$this->group["group_rss2_file_name"]);
			$this->assign('BCRssAtomURL',CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/".$this->group["group_atom_file_name"]);
			$this->assign('BCRssCopyright',$this->group["group_rss_copyright"]);
			$this->assign('BCRssCreator',$this->group["group_rss_creator"]);
			$this->assign('BCRssDate',$this->group["group_modification_date"]);
		}
	}
	
	function assignRSSTags($group_code)
	{
		$dao = new EntryManager();
		$rss = $dao->getRSSList($group_code);
		
		if($rss->RecordCount() > 0)
		{
			while(!$rss->EOF)
			{
				$entry["description"] = $rss->fields["entry_body"];
				$entry["description"] = strip_tags($entry["description"]);
				$entry["description"] = str_replace("\n","",$entry["description"]);
				$entry["description"] = mb_substr($entry["description"],0,$rss->fields["group_summary_strings_num"]);
				
				$rss_entrys_array[] = array(
					'ID' => $rss->fields["entry_code"],
					'Title' => $rss->fields["entry_title"],
					'URL' => CURRENT_HTTP_SERVER.$rss->fields["group_dir_name"]."/news".$rss->fields["entry_code"].".html",
					'Date' => $rss->fields["entry_date"],
					'Description' => $entry["description"],
					'CategoryName' => $rss->fields["category_name"]);
				$rss->MoveNext();
			}
			$this->assign('BCRssEntrys', $rss_entrys_array);
		}
	}
	
	function assignCurrentCategoryTags($category_code)
	{
		$dao = new CategoryManager();
		$category = $dao->getCategoryInfo($category_code);
		
		if($category)
		{
			$current_category_array = array(
				'ID' => $category["category_code"],
				'Name' => $category["category_name"],
				'URL' => CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/category".$category["category_code"].".html");
			
			$this->assign('BCCurrentCategory', $current_category_array);
		}
	}
	
	function assignCurrentEntryTags($entry_code)
	{
		$dao = new EntryManager();
		$entry = $dao->getEntryInfo($entry_code);
		
		if($entry)
		{
			$entry["description"] = $entry["entry_body"];
			$entry["description"] = strip_tags($entry["description"]);
			$entry["description"] = str_replace("\n","",$entry["description"]);
			$entry["description"] = mb_substr($entry["description"],0,$this->group["group_summary_strings_num"]);
			
			$current_entry_array = array(
				'ID' => $entry["entry_code"],
				'Title' => $entry["entry_title"],
				'URL' => CURRENT_HTTP_SERVER.$this->group["group_dir_name"]."/news".$entry["entry_code"].".html",
				'Date' => $entry["entry_date"],
				'Description' => $entry["description"],
				'CategoryName' => $entry["category_name"],
				'Body' => $entry["entry_body"]);
			
			$this->assign('BCCurrentEntry', $current_entry_array);
		}
	}
}
