<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryFormPreview.class.php
 * @brief		記事登録プレビュークラス
 * @date		2007.01.22
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");
require_once(CLASS_DIR."/adodb/TemplateManager.class.php");

class EntryFormPreview extends ViewRender
{
	function makeView()
	{
		$template_dao = new TemplateManager();
		$template = $template_dao->getTemplateInfo($_GET["group_code"]);
		if(!$template)
			$this->error("テンプレート情報の取得に失敗しました。");
		
		$this->assignBitcubeTags($_GET["group_code"],$_SESSION["entry_preview"]["category"]);
		$this->assignPreviewEntryTags();
		
		$this->register_resource("tpl");
		$this->template = "tpl:".preg_replace("/".preg_quote("<[$BCCurrentEntry.Body]>","/")."/",$_SESSION["entry_preview"]["body"],$template["news_detail_tmpl"]);
	}
	
	function assignPreviewEntryTags()
	{
		$group_dao = new GroupManager();
		$group = $group_dao->getGroupInfo($_GET["group_code"]);
		
		$category_dao = new CategoryManager();
		$category = $category_dao->getCategoryInfo($_SESSION["entry_preview"]["category"]);
		
		$entry["entry_code"] = ($_GET["entry_code"]) ? $_GET["entry_code"]: 0;
		$entry["entry_date"] = str_replace("'","",$group_dao->DBTimeStamp());
		
		$entry["description"] = $_SESSION["entry_preview"]["body"];
		$entry["description"] = strip_tags($entry["description"]);
		$entry["description"] = str_replace("\n","",$entry["description"]);
		$entry["description"] = mb_substr($entry["description"],0,$group["group_summary_strings_num"]);
		
		$current_entry_array = array(
			'ID' => $entry["entry_code"],
			'Title' => $_SESSION["entry_preview"]["title"],
			'URL' => CURRENT_HTTP_SERVER.$group["group_dir_name"]."/news".$entry["entry_code"].".html",
			'Date' => $entry["entry_date"],
			'Description' => $entry["description"],
			'CategoryName' => $category["category_name"],
			'Body' => $_SESSION["entry_preview"]["body"]);
		
		$this->assign('BCCurrentEntry', $current_entry_array);
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
