<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralCategoryManager.class.php
 * @brief		一般用カテゴリーページクラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class GeneralCategoryManager extends BitcubeDB
{
	function GeneralCategoryManager()
	{
		$this->BitcubeDB();
	}
	
	// タイトル取得
	function getCategoryTitle($category_code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->category.category_name ";
		$sql .= " from ";
		$sql .= " $this->category ";
		$sql .= " where $this->category.is_delete = 0 and $this->category.category_code = $category_code ";
		
		return $this->GetOne($sql);
	}
	
	// カテゴリーページ情報取得
	function getCategoryInfo($group_code,$category_code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->category.category_code ";
		$sql .= " ,$this->category.group_code ";
		$sql .= " ,$this->template.category_page_tmpl ";
		$sql .= " from ";
		$sql .= " $this->category left outer join $this->template on $this->template.group_code = $this->category.group_code ";
		$sql .= " where $this->category.is_delete = 0 and $this->category.group_code = $group_code and $this->category.category_code = $category_code ";
		
		return $this->GetRow($sql);
	}
}
