<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralSitemapManager.class.php
 * @brief		一般用サイトマップクラス
 * @date		2007.03.26
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class GeneralSitemapManager extends BitcubeDB
{
	function GeneralSitemapManager()
	{
		$this->BitcubeDB();
	}
	
	// 更新セットチェック
	function getGroupDirName($group_code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->group.group_dir_name ";
		$sql .= " from ";
		$sql .= " $this->group ";
		$sql .= " where $this->group.is_delete = 0 and $this->group.group_code = ".$this->qstr($group_code);
		
		return $this->GetOne($sql);
	}
	
	// カテゴリコード一覧取得
	function getCategoryCodeList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		$sql  = " select ";
		$sql .= " $this->category.category_code ";
		$sql .= " from ";
		$sql .= " $this->category ";
		
		$condition = ($condition) ?
			" where $this->category.is_delete = 0 and $condition ":
			" where $this->category.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
	
	// 記事詳細コード一覧取得
	function getNewsCodeList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " from ";
		$sql .= " $this->entry ";
		
		$condition = ($condition) ?
			" where $this->entry.is_delete = 0 and $this->entry.entry_publish = 1 and $condition ":
			" where $this->entry.is_delete = 0 and $this->entry.entry_publish = 1 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
}
