<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		object.php
 * @brief		フロントコントローラ実体
 * @date		2006.12.16
 */

// ユーザ設定ファイルが無ければインストーラ起動
if(!file_exists("./user.config.php"))
{
	$_POST["InstallMode"] = true;	// インストーラモード
	require_once("./modules/BitcubeInstall.php");
}

require_once("./user.config.php");				// ユーザ環境設定
require_once("./config/config.php");			// 設定
require_once(SYSTEM_PATH."common/common.php");	// 共通処理

switch($_GET["mode"])
{
	case   1 :require_once(MODULE_DIR."/EntryList.php");break;				// エントリー一覧
	case   2 :require_once(MODULE_DIR."/GroupEntry.php");break;				// 更新セットの新規登録
	case   3 :require_once(MODULE_DIR."/Menu.php");break;					// 総合メニュー
	case   4 :require_once(MODULE_DIR."/GroupFileUpload.php");break;		// 更新セット画像アップロード
	case   5 :require_once(MODULE_DIR."/EntryFileUpload.php");break;		// 記事画像アップロード
	case   6 :require_once(MODULE_DIR."/GroupEdit.php");break;				// 更新セットの編集
	case   7 :require_once(MODULE_DIR."/RSSEdit.php");break;				// RSS設定の編集
	case   8 :require_once(MODULE_DIR."/TemplateList.php");break;			// テンプレート一覧
	case   9 :require_once(MODULE_DIR."/SendPingEdit.php");break;			// 記事をPRする先の編集
	case  10 :require_once(MODULE_DIR."/EnvInfo.php");break;				// 環境情報
	case  11 :require_once(MODULE_DIR."/NewEntryFileUpload.php");break;		// 新規登録記事画像アップロード
	case  12 :require_once(MODULE_DIR."/Restruct.php");break;				// サイトの再構築
	case  13 :require_once(MODULE_DIR."/EntryEntry.php");break;				// 記事の新規登録
	case  14 :require_once(MODULE_DIR."/EntryEdit.php");break;				// 記事の編集
	case  15 :require_once(MODULE_DIR."/CategoryList.php");break;			// カテゴリ一覧
	case  16 :require_once(MODULE_DIR."/TemplateModuleEntry.php");break;	// モジュールテンプレートの新規登録
	case  17 :require_once(MODULE_DIR."/TemplateModuleEdit.php");break;		// モジュールテンプレートの編集
	case  18 :require_once(MODULE_DIR."/CategoryEntry.php");break;			// カテゴリの新規登録
	case  19 :require_once(MODULE_DIR."/CategoryEdit.php");break;			// カテゴリの編集
	case  20 :require_once(MODULE_DIR."/CategoryDelete.php");break;			// カテゴリの削除
	case  21 :require_once(MODULE_DIR."/CategoryOrder.php");break;			// カテゴリのオーダー入れかえ
	case  22 :require_once(MODULE_DIR."/EntryCopy.php");break;				// 記事の複製
	case  23 :require_once(MODULE_DIR."/EntryDelete.php");break;			// 記事の削除
	case  24 :require_once(MODULE_DIR."/EntryPublish.php");break;			// 記事の掲載
	case  25 :require_once(MODULE_DIR."/EntryNonPublish.php");break;		// 記事の非掲載
	case  26 :require_once(MODULE_DIR."/Export.php");break;					// エクスポート
	case  27 :require_once(MODULE_DIR."/TrashList.php");break;				// ごみ箱
	case  28 :require_once(MODULE_DIR."/GroupDelete.php");break;			// 更新セットの削除
	case  29 :require_once(MODULE_DIR."/TrashReturn.php");break;			// ごみ箱から元に戻す
	case  30 :require_once(MODULE_DIR."/TrashDelete.php");break;			// ごみ箱から削除
	case  31 :require_once(MODULE_DIR."/Logout.php");break;					// ログアウト
	case  32 :require_once(MODULE_DIR."/AccountEdit.php");break;			// ユーザ設定
	case  33 :require_once(MODULE_DIR."/EntryFormPreview.php");break;		// 記事登録プレビュー
	case  34 :require_once(MODULE_DIR."/EntryPreview.php");break;			// 記事プレビュー
	case  35 :require_once(MODULE_DIR."/TemplateRSS1Edit.php");break;		// RSS1.0テンプレートの編集
	case  36 :require_once(MODULE_DIR."/TemplateRSS2Edit.php");break;		// RSS2.0テンプレートの編集
	case  37 :require_once(MODULE_DIR."/TemplateATOMEdit.php");break;		// ATOMテンプレートの編集
	case  38 :require_once(MODULE_DIR."/TemplateTopEdit.php");break;		// トップページテンプレートの編集
	case  39 :require_once(MODULE_DIR."/TemplateCategoryEdit.php");break;	// カテゴリページテンプレートの編集
	case  40 :require_once(MODULE_DIR."/TemplateNewsEdit.php");break;		// ニュース詳細ページテンプレートの編集
	case  41 :require_once(MODULE_DIR."/TemplateModuleDelete.php");break;	// モジュールテンプレートの削除
	case  42 :require_once(MODULE_DIR."/GeneralTopView.php");break;			// 一般用トップページビュー
	case  43 :require_once(MODULE_DIR."/GeneralCategoryView.php");break;	// 一般用カテゴリページビュー
	case  44 :require_once(MODULE_DIR."/GeneralNewsView.php");break;		// 一般用ニュース詳細ページビュー
	case  45 :require_once(MODULE_DIR."/GeneralModuleView.php");break;		// 一般用モジュールビュー
	case  46 :require_once(MODULE_DIR."/GeneralRSS1View.php");break;		// 一般用RSS1.0ビュー
	case  47 :require_once(MODULE_DIR."/GeneralRSS2View.php");break;		// 一般用RSS2.0ビュー
	case  48 :require_once(MODULE_DIR."/GeneralATOMView.php");break;		// 一般用ATOMビュー
	case  49 :require_once(MODULE_DIR."/EntryOrder.php");break;				// 記事のオーダー入れかえ
	case  50 :require_once(MODULE_DIR."/AccessLogPop.php");break;			// 人気ページ
	case  51 :require_once(MODULE_DIR."/AccessLogDate.php");break;			// 月/日別アクセス
	case  52 :require_once(MODULE_DIR."/AccessLogTrans.php");break;			// ユーザ遷移
	case  53 :require_once(MODULE_DIR."/AccessLogRefer.php");break;			// リンク元
	case  54 :require_once(MODULE_DIR."/AccessLogWord.php");break;			// 検索ワード
	case  55 :require_once(MODULE_DIR."/Import.php");break;					// インポート
	case  56 :require_once(MODULE_DIR."/GeneralSitemapView.php");break;		// 一般用サイトマップビュー
	case  57 :require_once(MODULE_DIR."/TemplateBaseCSSEdit.php");break;	// base.cssテンプレートの編集
	case  58 :require_once(MODULE_DIR."/TemplateBCCSSEdit.php");break;		// bitcube.cssテンプレートの編集
	case  59 :require_once(MODULE_DIR."/TemplateBCIE5CSSEdit.php");break;	// bitcube_ie5win.cssテンプレートの編集
	case  60 :require_once(MODULE_DIR."/GeneralBaseCSSView.php");break;		// 一般用CSSビュー(base.css)
	case  61 :require_once(MODULE_DIR."/GeneralBCCSSView.php");break;		// 一般用CSSビュー(bitcube.css)
	case  62 :require_once(MODULE_DIR."/GeneralBCIE5CSSView.php");break;	// 一般用CSSビュー(bitcube_ie5win.css)
	default  :require_once(MODULE_DIR."/Menu.php");break;					// 総合メニュー
}
