<?php
/*
 * @file		block.BCNorCategorys.php
 * @brief		
 * @author		Tomomi Yamamoto
 * @date		2007.04.23
 ***************************************************************************
 *	リスト・コンテナタグ：
 *　　bitCubeのカテゴリ情報用、コンテナ・タグです。
 *　　アトリビュートで指定した特定のカテゴリ以外のカテゴリを一覧することができます。
 *  属性
 *    categroy_code = ""
 *     ・指定されたカテゴリコード以外の情報を取得します。
 *    category_name = ""
 *     ・指定されたカテゴリ名以外の情報を取得します。
 *    group_code = N
 *     ・指定されたグループ番号の情報を取得します。
 *    group_name = ""
 *     ・指定されたグループ名の情報を取得します。
 *　　lastn = N
 *     ・指定された件数を表示します。
 *    sort_by = "category_code|category_order"
 *     ・並び替える対象を指定します。
 * 　　　category_code（カテゴリコード順）、
 * 　　　category_order（カテゴリ並び順）、
 *    sort_order="ascend | descend"
 *     ・並べる順序を指定します。ascendを指定すると昇順、descendは降順になります。
 *　使用方法
 *	　<[BCNorCategorys]><[/BCNorCategorys]>
 ***************************************************************************
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

function smarty_block_BCNorCategorys($params, $content, &$smarty, &$repeat)
{	
	static $instance_cnt 	= 0;			//インスタンス生成数
	static $aryloopcnt		= array();		//処理待機用配列
	static $aryrs			= array();		//検索結果待機用配列
	static $aryattribute	= array();		//属性待機用配列
	static $aryNestValue	= array();		//タグネスト時の値を待機

	//*********************
	//「開始タグ」
	//*********************
	if(is_null($content))	//コンテンツ=nullでループ回数=0の場合は初期
	{
		//初期処理
		init_BCNorCategorys($params,&$rs);
		
		//属性設定
		attribute_BCNorCategorys($params,&$rs,&$attribute);

		//初期化
		$loopcnt = 0;
		
		//インスタンス生成数制御
		$instance_cnt++;

		$aryNestValue[$instance_cnt] = $smarty->_tpl_vars["BCNorCategorys"];
		
		//結果を配列へ待機
		$aryloopcnt[$instance_cnt] = $loopcnt;
		$aryrs[$instance_cnt] = $rs;
		$aryattribute[$instance_cnt] = $attribute;
		
	}

	//現在処理している情報を取得
	$loopcnt 		= $aryloopcnt[$instance_cnt];
	$rs					= $aryrs[$instance_cnt];
	$attribute	= $aryattribute[$instance_cnt];
	
	//*********************
	//「共通処理」
	//*********************
	//チェック処理
	$rtn = check_BCNorCategorys(&$loopcnt,&$rs);
	if(!$rtn)
	{
		//終了処理		
		terminate_BCNorCategorys(&$smarty,$instance_cnt,$aryNestValue[$instance_cnt]);
		$repeat = false;
		return $content;
	}	

	//メイン処理
	main_BCNorCategorys(&$smarty,&$loopcnt,&$rs);

	//処理回数を待機
	$aryloopcnt[$instance_cnt] = $loopcnt;
	
	//*********************
	//「終了タグ」
	//*********************
	if(!is_null($content))
	{	
		if($loopcnt>$attribute['lastn'])
		{
			//終了処理
			terminate_BCNorCategorys(&$smarty,$instance_cnt,$aryNestValue[$instance_cnt]);
			$repeat = false;
			return $content;
		}
		else
		{
			//処理継続
			$repeat = true;
			return $content;
		}			
	}
}

/*
 * 
 */
function init_BCNorCategorys($params,&$rs)
{
	$dao = new BitcubeDB();
	
	//------------------------------
	//開始タグ時
	//------------------------------
	$sql  = " select distinct ";
	$sql .= " $dao->category.category_code ";
	$sql .= " ,$dao->category.group_code ";
	$sql .= " ,$dao->category.category_name ";
	$sql .= " ,$dao->category.category_order ";
	$sql .= " ,$dao->group.group_regist_date ";
	$sql .= " ,$dao->group.group_modification_date ";
	$sql .= " ,$dao->group.group_name ";
	$sql .= " ,$dao->group.group_meta_description ";
	$sql .= " ,$dao->group.group_meta_keyword ";
	$sql .= " ,$dao->group.group_dir_name ";
	$sql .= " ,$dao->group.group_upload_dir_name ";
	$sql .= " ,$dao->group.group_default_publish ";
	$sql .= " ,$dao->group.group_summary_strings_num ";
	$sql .= " ,$dao->group.group_rss_output_num ";
	$sql .= " ,$dao->group.group_rss1_output ";
	$sql .= " ,$dao->group.group_rss1_file_name ";
	$sql .= " ,$dao->group.group_rss2_output ";
	$sql .= " ,$dao->group.group_rss2_file_name ";
	$sql .= " ,$dao->group.group_atom_output ";
	$sql .= " ,$dao->group.group_atom_file_name ";
	$sql .= " ,$dao->group.group_rss_copyright ";
	$sql .= " ,$dao->group.group_rss_creator ";
	$sql .= " ,$dao->group.group_ping_other_sites ";
	$sql .= " ,(case when c.entry_count is null then 0 else c.entry_count end) as entry_count ";
	$sql .= " from ";
	$sql .= " $dao->category left join $dao->group on $dao->category.group_code = $dao->group.group_code "; 
	$sql .= " left join (select ";
	$sql .= " entry_code ";
	$sql .= " ,category_code ";
	$sql .= " ,group_code ";
	$sql .= " ,count(*) as entry_count "; 
	$sql .= " from $dao->entry ";
	$sql .= " where ($dao->entry.is_delete = 0) ";
	$sql .= " group by  ";
	$sql .= " entry_code ";
	$sql .= " ,category_code ";
	$sql .= " ,group_code ";
	$sql .= " ) c on $dao->category.category_code = c.category_code and $dao->group.group_code = c.group_code ";
	
	//---------------
	//検索条件設定
	//---------------
	$temp_con = null;
	if(isset($params['group_code']) && $params['group_code'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCNorCategorys($params['group_code'],$dao->group.'.group_code','int');
	}
	elseif(isset($params['group_name']) && $params['group_name'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCNorCategorys($params['group_name'],$dao->group.'.group_name','char');
	}
	if(isset($temp_con))
	{
		if(isset($condition))
		{
			$condition .= ' and ';
		}
		$condition .= '('.$temp_con.')';
	}
	
	$temp_con = null;
	if(isset($params['category_code']) && $params['category_code'] != "")
	{
		$temp_con = getCondition_BCNorCategorys($params['category_code'],$dao->category.'.category_code','int');
	}
	elseif(isset($params['category_name']) && $params['category_name'] != "")
	{
		//条件文生成
		$temp_con = getCondition_BCNorCategorys($params['category_name'],$dao->category.'.category_name','char');
	}
	if(isset($temp_con))
	{
		if(isset($condition))
		{
			$condition .= ' and ';
		}
		$condition .= '('.$temp_con.')';
	}
	
	$order = "";
	switch($params['sort_order'])
	{
		case "ascend":	{$order=" asc ";break;	}
		case "descend":	{$order=" desc ";break;	}
		default:{$order=" ";break;}
	}
	
	//並び替え設定
	//存在すればここで処理
	switch($params['sort_by'])
	{
		case "category_code":	{$orderby="$dao->category.category_code".$order;break;	}
		case "category_order":	{$orderby="$dao->category.category_order".$order;break;	}
		default:{$orderby="$dao->category.category_order"." desc ";break;}
	}
	
	if($condition!="")
	{
		$sql .= " where $dao->category.is_delete = 0 and ".$condition;
	}
	else
	{
		$sql .= " where $dao->category.is_delete = 0 ";
	}
	
	if($orderby!="")
	{
		$sql .= " order by ".$orderby;
	}
	
	$rs = array();
	$rs = $dao->GetAll($sql);
}

/*
 * 
 */
function attribute_BCNorCategorys($params,&$rs,&$attribute)
{
	
	//表示件数設定
	//※未設定時には全て
	if(isset($params['lastn']) && $params['lastn'] != "")
	{
		$lastn = $params['lastn'];
	}
	else
	{
		$lastn = count($rs);
	}
	if($lastn>count($rs))
	{
		$lastn = count($rs);
	}
	
	//属性セット
	$attribute['lastn'] = $lastn;
}
/*
 * 
 * 
 */
function check_BCNorCategorys(&$loopcnt,&$rs)
{
	//対象データ存在チェック
	if(($loopcnt+1)>count($rs))
	{
		return false;
	}

	return true;
}
 
/*
 * 
 */
function main_BCNorCategorys(&$smarty,&$loopcnt,&$rs)
{
	//テンプレート変数へセット
	$items = array();

	$items['CategoryCode'] = $rs[$loopcnt]['category_code'];
	$items['GroupCode'] = $rs[$loopcnt]['group_code'];
	$items['CategoryName'] = $rs[$loopcnt]['category_name'];
	$items['CategoryOrder'] = $rs[$loopcnt]['category_order'];
	$items['GroupRegistDate'] = $rs[$loopcnt]['group_regist_date'];
	$items['GroupModificationDate'] = $rs[$loopcnt]['group_modification_date'];
	$items['GroupName'] = $rs[$loopcnt]['group_name'];
	$items['GroupMetaDescription'] = $rs[$loopcnt]['group_meta_description'];
	$items['GroupMetaKeyword'] = $rs[$loopcnt]['group_meta_keyword'];
	$items['GroupHttpServerDirPath'] = CURRENT_HTTP_SERVER.$rs[$loopcnt]['group_dir_name']."/";
	$items['GroupUploadDirPath'] = CURRENT_HTTP_SERVER.$rs[$loopcnt]['group_dir_name']."/".$rs[$loopcnt]['group_upload_dir_name']."/";
	$items['GroupDefaultPublish'] = $rs[$loopcnt]['group_default_publish'];
	$items['GroupSummaryStringsNum'] = $rs[$loopcnt]['group_summary_strings_num'];
	$items['GroupRssOutputNum'] = $rs[$loopcnt]['group_rss_output_num'];
	$items['GroupRss1Output'] = $rs[$loopcnt]['group_rss1_output'];
	$items['GroupRss1FileName'] = $rs[$loopcnt]['group_rss1_file_name'];
	$items['GroupRss2Output'] = $rs[$loopcnt]['group_rss2_output'];
	$items['GroupRss2FileName'] = $rs[$loopcnt]['group_rss2_file_name'];
	$items['GroupAtomOutput'] = $rs[$loopcnt]['group_atom_output'];
	$items['GroupAtomFileName'] = $rs[$loopcnt]['group_atom_file_name'];
	$items['GroupRssCopyright'] = $rs[$loopcnt]['group_rss_copyright'];
	$items['GroupRssCreator'] = $rs[$loopcnt]['group_rss_creator'];
	$items['GroupPingOtherSites'] = $rs[$loopcnt]['group_ping_other_sites'];
	$items['EntryCount'] = $rs[$loopcnt]['entry_count'];
	
	//テンプレート変数へセット
	$smarty->assign("BCNorCategorys", $items);
	
	$loopcnt++;
}

/*
 * 
 */
function terminate_BCNorCategorys(&$smarty,&$instance_cnt,$aryNestValue)
{
	$smarty->clear_assign("BCCategorys");
	
	//インスタンス生成数をカウントダウン
	$instance_cnt--;

	if($instance_cnt > 0)
	{
		if(isset($aryNestValue))
		{
			$smarty->assign("BCCategorys",$aryNestValue);
		}
	}
	
}

function getCondition_BCNorCategorys($value,$fieldname,$type)
{
	$temp_condition = "";
	$items = split(",",$value);

	$dao = new BitcubeDB();

	foreach($items as $item)
	{
		if(isset($temp_con))
		{
			$temp_condition = $temp_condition." or ";
		}
		
		switch($type)
		{
			case "int":
			{
				if ($fieldname == $dao->category.'.category_code')
				{
					$temp_condition = $temp_condition.$fieldname."!=".$item;
				}
				else
				{
					$temp_condition = $temp_condition.$fieldname."=".$item;
				}
				break;
			}
			default:
			{
				if ($fieldname == $dao->category.'.category_name')
				{
					$temp_condition = $temp_condition.$fieldname."!='".$item."'";
				}
				else
				{
					$temp_condition = $temp_condition.$fieldname."='".$item."'";
				}
				break;
			}
		}	
	}
	
	return $temp_condition;
}
?>