<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccessLogRefer.class.php
 * @brief		リンク元クラス
 * @date		2007.02.07
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class AccessLogRefer extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; リンク元ランキング");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		// POSTデータが無い場合の初期値を設定
		if(!$_POST["period"])
			$_POST["period"] = "30";
		
		// ファイルからログ読み込み
		for($count = LOG_DIV; $count > 0; $count--)
		{
			if($fp = fopen(LOG_DIR."/log_".$_GET["group_code"]."_".$count.".dat","r"))
			{
				$period = strtotime("-".$_POST["period"]." day");
				while(!feof($fp))
				{
					$log = fgets($fp);
					if(!is_bool($log))
					{
						// 抽出処理
						$temp = explode("\t",rtrim($log));
						if($temp["0"] > $period)
							if(!preg_match("/^".preg_quote(CURRENT_HTTP_SERVER,"/")."/",$temp["2"]))
								$refer_array[$temp["2"]]++;
					}
				}
				fclose($fp);
			}
		}
		
		// ソート
		arsort($refer_array);
		
		$this->assign("period",$_POST["period"]);
		$this->assign("refer_array",$refer_array);
		
		$this->template = "AccessLogRefer.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
