<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccessLogWord.class.php
 * @brief		検索ワードクラス
 * @date		2007.02.07
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class AccessLogWord extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; 検索ワードランキング");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		// POSTデータが無い場合の初期値を設定
		if(!$_POST["period"])
			$_POST["period"] = "30";
		
		// ファイルからログ読み込み
		for($count = LOG_DIV; $count > 0; $count--)
		{
			if($fp = fopen(LOG_DIR."/log_".$_GET["group_code"]."_".$count.".dat","r"))
			{
				$period = strtotime("-".$_POST["period"]." day");
				while(!feof($fp))
				{
					$log = fgets($fp);
					if(!is_bool($log))
					{
						// 抽出処理
						$temp = explode("\t",rtrim($log));
						if($temp["0"] > $period)
						{
							// google
							if(preg_match("/^http:\/\/www.google.co.jp\//",$temp["2"]))
							{
								preg_match("/q=([^&]+)/",$temp["2"],$query);
								$search_word = mb_convert_encoding(urldecode($query["1"]),"UTF-8","auto");
								$search_array[$search_word]++;
								$view_page[$search_word][$temp["3"]]++;
								$page_title[$temp["3"]] = $temp["4"];
							}
							
							// yahoo
							if(preg_match("/^http:\/\/search.yahoo.co.jp\//",$temp["2"]))
							{
								preg_match("/p=([^&]+)/",$temp["2"],$query);
								$search_word = mb_convert_encoding(urldecode($query["1"]),"UTF-8","auto");
								$search_array[$search_word]++;
								$view_page[$search_word][$temp["3"]]++;
								$page_title[$temp["3"]] = $temp["4"];
							}
						}
					}
				}
				fclose($fp);
			}
		}
		
		// ソート
		foreach($view_page as $key => $array)
			arsort($view_page[$key]);
		arsort($search_array);
		
		$this->assign("period",$_POST["period"]);
		$this->assign("search_array",$search_array);
		$this->assign("view_page",$view_page);
		$this->assign("page_title",$page_title);
		
		$this->template = "AccessLogWord.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
