<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralRSS1View.class.php
 * @brief		一般用RSS1.0ビュークラス
 * @date		2007.01.25
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralRSS1Manager.class.php");

class GeneralRSS1View extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralRSS1Manager();
		$rss1 = $dao->getRSS1Info($_GET["group_code"]);
		if(!$rss1)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($rss1["group_code"]);
		$this->assignRSSTags($rss1["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$rss1["rss1_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderRSSView();
	}
}
