<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		Login.class.php
 * @brief		ログインクラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/form/LoginForm.class.php");

class Login extends PageRender
{
	function makePage()
	{
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("user",$_POST["user"]);
		$this->template = "Login.tpl";
	}
	
	// 確認
	function confirm()
	{
		$form = new LoginForm;
		$form->setUserName($_POST["user"]);
		$form->setUserPass($_POST["pass"]);
		
		$this->assign("state",2);
		$this->assign("user",$_POST["user"]);
		$this->template = "Login.tpl";
	}
	
	function renderPage()
	{
		$this->display($this->template);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
