<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralNewsView.php
 * @brief		一般用ニュース詳細ページビュー
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/action/GeneralNewsView.class.php");
require_once(CLASS_DIR."/adodb/GeneralNewsManager.class.php");
require_once(CLASS_DIR."/log/WriteLog.class.php");

$page = new GeneralNewsView();
$page->render();

if(!$auth->isLogin())
{
	// ログ書き込み
	$news_dao = new GeneralNewsManager();
	$log = new WriteLog();
	$log->addLog($_GET["group_code"],$news_dao->getNewsTitle($_GET["entry_code"]));
	
	// 閲覧数追加
	if(!isset($_SESSION["access_time"][$_GET["entry_code"]]))
	{
		$news_dao->updPageView($_GET["entry_code"]);
		$_SESSION["access_time"][$_GET["entry_code"]] = time();
	}
	
	if((time() - $_SESSION["access_time"][$_GET["entry_code"]]) > PAGE_VIEW_INVALID_TIME)
	{
		$news_dao->updPageView($_GET["entry_code"]);
		$_SESSION["access_time"][$_GET["entry_code"]] = time();
	}
}
