<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryEdit.class.php
 * @brief		記事の編集クラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/form/EntryInputForm.class.php");
require_once(CLASS_DIR."/blog/weblogUpdates.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class EntryEdit extends EntryInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; <a href=\"./index.php?mode=1&group_code=".$_GET["group_code"]."\">記事一覧</a> &gt; 記事編集");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		$entry = new EntryManager();
		$this->current_entry = $entry->getEntryInfo($_GET["entry_code"]);
		if(!count($this->current_entry) > 0)
			$this->error("記事情報の取得に失敗しました。");
		$this->assign("current_entry",$this->current_entry);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			case 4 :{$this->draft();break;}		// 下書き
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$category_dao = new CategoryManager();
		$group_category_array = $category_dao->getCategoryList("$category_dao->category.category_code asc","$category_dao->category.group_code = ".$_GET["group_code"]);
		$this->assign("group_category_array",$group_category_array);
		
		$this->assign("state",2);
		$this->assign("title",$this->current_entry["entry_title"]);
		$this->assign("category",$this->current_entry["category_code"]);
		$this->assign("date",date("Y-m-d",strtotime($this->current_entry["entry_date"])));
		$this->assign("body",$this->current_entry["entry_body"]);
		$this->assign("ping",$this->current_group["group_default_publish"]);
		$this->assign("START_YEAR",START_YEAR);
		$this->assign("END_YEAR",START_YEAR);
		$this->template = "EntryEditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setEntryTitle($_POST["title"]);
		$this->setCategoryCode($_POST["category"]);
		$this->setEntryBody($_POST["body"]);
		$form_error_array = $this->check();
		
		$category_dao = new CategoryManager();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$group_category_array = $category_dao->getCategoryList("$category_dao->category.category_code asc","$category_dao->category.group_code = ".$_GET["group_code"]);
			$this->assign("group_category_array",$group_category_array);
			
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->assign("START_YEAR",START_YEAR);
			$this->assign("END_YEAR",START_YEAR);
			$this->template = "EntryEditInput.tpl";
		}
		else
		{
			$_SESSION["entry_preview"] = array();
			$_SESSION["entry_preview"]["title"] = $_POST["title"];
			$_SESSION["entry_preview"]["category"] = $_POST["category"];
			$_SESSION["entry_preview"]["body"] = $_POST["body"];
			
			$category_info = $category_dao->getCategoryInfo($_POST["category"]);
			$this->assign("category_info",$category_info);
			
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "EntryEditConfirm.tpl";
		}
		
		$this->assign("title",$_POST["title"]);
		$this->assign("category",$_POST["category"]);
		$this->assign("date",$_POST["Date_Year"]."-".$_POST["Date_Month"]."-".$_POST["Date_Day"]);
		$this->assign("body",$_POST["body"]);
		$this->assign("ping",$_POST["ping"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_code"] = $_GET["group_code"];
		$record["category_code"] = $_POST["category"];
		$record["entry_date"] = $_POST["Date_Year"]."-".$_POST["Date_Month"]."-".$_POST["Date_Day"];
		$record["entry_title"] = $_POST["title"];
		$record["entry_body"] = $_POST["body"];
		$record["entry_publish"] = ($_POST["ping"] > 0) ? 1: $this->current_group["group_default_publish"];
		$code = $_GET["entry_code"];
		
		$dao = new EntryManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->updEntry($record,$code);
		if(!$dao->CompleteTrans())
			$this->error("記事の修正に失敗しました。");
		session_unregister("entry_preview");
		
		$sendping = new weblogUpdates();
		
		if($_POST["ping"] > 0)
		{
			$servers = explode("\n",$this->current_group["group_ping_other_sites"]);
			foreach($servers as $server)
				$sendping->SendUpdatePing(trim($server),$_POST["title"],CURRENT_HTTP_SERVER.$this->current_group["group_dir_name"]."/news".$_GET["entry_code"].".html");
			$message_array[] = "更新を通知しました。";
		}
		
		$exping_server = BITLIST."XMLRPC/";
		$exping_name = $_POST["title"];
		$exping_url = CURRENT_HTTP_SERVER.$this->current_group["group_dir_name"]."/news".$_GET["entry_code"].".html";
		$exping_c_url = CURRENT_HTTP_SERVER.$this->current_group["group_dir_name"];
		if($this->current_group["group_rss2_output"])
			$exping_rss = CURRENT_HTTP_SERVER.$this->current_group["group_dir_name"]."/".$this->current_group["group_rss2_file_name"];
		else if($this->current_group["group_rss1_output"])
			$exping_rss = CURRENT_HTTP_SERVER.$this->current_group["group_dir_name"]."/".$this->current_group["group_rss1_file_name"];
		else if($this->current_group["group_atom_output"])
			$exping_rss = CURRENT_HTTP_SERVER.$this->current_group["group_dir_name"]."/".$this->current_group["group_atom_file_name"];
		else
			$exping_rss = "";
		$exping_category = BL_CATEGORY;
		$sendping->SendUpdateExtendedPing($exping_server,$exping_name,$exping_url,$exping_c_url,$exping_rss,$exping_category);
		
		$send_vars["mode"] = 1;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	// 下書き
	function draft()
	{
		$record = array();
		$record["group_code"] = $_GET["group_code"];
		$record["category_code"] = $_POST["category"];
		$record["entry_date"] = $_POST["Date_Year"]."-".$_POST["Date_Month"]."-".$_POST["Date_Day"];
		$record["entry_title"] = (strlen($_POST["title"]) > 0) ? $_POST["title"] : "タイトル未定";
		$record["entry_body"] = $_POST["body"];
		$record["entry_publish"] = 0;
		$code = $_GET["entry_code"];
		
		$dao = new EntryManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->updEntry($record,$code);
		if(!$dao->CompleteTrans())
			$this->error("記事の修正に失敗しました。");
		session_unregister("entry_preview");
		
		$send_vars["mode"] = 1;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
