<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryPreview.class.php
 * @brief		ニュース詳細ページプレビュークラス
 * @date		2007.01.23
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");
require_once(CLASS_DIR."/adodb/TemplateManager.class.php");

class EntryPreview extends ViewRender
{
	function makeView()
	{
		$template_dao = new TemplateManager();
		$template = $template_dao->getTemplateInfo($_GET["group_code"]);
		if(!$template)
			$this->error("テンプレート情報の取得に失敗しました。");
		
		$entry_dao = new EntryManager();
		$entry = $entry_dao->getEntryInfo($_GET["entry_code"]);
		if(!$entry)
			$this->error("記事情報の取得に失敗しました。");
		
		$this->assignBitcubeTags($entry["group_code"],$entry["category_code"],$entry["entry_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".preg_replace("/".preg_quote("<[$BCCurrentEntry.Body]>","/")."/",$entry["entry_body"],$template["news_detail_tmpl"]);
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
