<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralRSS2View.class.php
 * @brief		一般用RSS2.0ビュークラス
 * @date		2007.01.25
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralRSS2Manager.class.php");

class GeneralRSS2View extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralRSS2Manager();
		$rss2 = $dao->getRSS2Info($_GET["group_code"]);
		if(!$rss2)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($rss2["group_code"]);
		$this->assignRSSTags($rss2["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$rss2["rss2_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderRSSView();
	}
}
