<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		Restruct.class.php
 * @brief		サイトの再構築クラス
 * @date		2007.03.05
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/file/MakeHtaccess.class.php");
require_once(CLASS_DIR."/file/CheckDirectory.class.php");

class Restruct extends PageRender
{
	function makePage()
	{
		// キャッシュディレクトリ再構築
		system("rm -r \"".CACHE_DIR."\" ");
		mkdir(CACHE_DIR);
		
		// htaccess再構築
		$htaccess = new MakeHtaccess();
		if(!$htaccess->execute())
			$this->error("サイトの再構築に失敗しました。");
		
		// ディレクトリ再構築
		$check_dir = new CheckDirectory();
		
		$send_vars["mode"] = 10;
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
