<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AbstractDB.class.php
 * @brief		データベース処理抽象基底クラス
 * @date		2006.12.14
 */

require_once(LIBRARY_DIR."/adodb/adodb.inc.php");

class AbstractDB
{
	// DBコネクション確立
	function AbstractDB($debug=false)
	{
		$this->db = NewADOConnection(DB_TYPE);
		$this->db->Connect(DB_HOST,DB_USER,DB_PASS,DB_NAME);
		$this->db->SetFetchMode(ADODB_FETCH_ASSOC);
		
		$this->db->debug = $debug;
		
		if(DB_TYPE == "postgres")
			$this->Execute("set client_encoding to ".$this->qstr("UNICODE"));
		else if(DB_TYPE == "mysql")
			$this->Execute("set names ".$this->qstr("utf8"));
	}
	
	// 最後の状態あるいはエラーメッセージを返す
	function getErrorMsg()
	{
		return $this->db->ErrorMsg();
	}
	
	// 最後のエラー番号を返す
	function getErrorNo()
	{
		return $this->db->ErrorNo();
	}
	
	// SQLステートメントを実行する
	function Execute($sql)
	{
		return $this->db->Execute($sql);
	}
	
	// レコードセットのページングを2次元配列として返す
	function PageExecute($sql,$nrows,$page,$inputarr=false)
	{
		return $this->db->PageExecute($sql,$nrows,$page,$inputarr);
	}
	
	// すべての行を2次元配列として返す
	function GetAll($sql)
	{
		return $this->db->GetAll($sql);
	}
	
	// 最初の行の最初のフィールドの値を返す
	function GetOne($sql)
	{
		return $this->db->GetOne($sql);
	}
	
	// 最初の行を配列として返す
	function GetRow($sql)
	{
		return $this->db->GetRow($sql);
	}
	
	// 最大値を取得
	function GetMax($table,$record,$condition="")
	{
		if($condition)
			$condition = " where ".$condition;
		
		$max = $this->GetOne("select max(".$record.") from ".$table.$condition);
		
		return ($max) ? $max : 0;
	}
	
	// 件数を取得
	function GetCount($table,$condition="")
	{
		if($condition)
			$condition = " where ".$condition;
		return $this->GetOne("select count(*) from ".$table.$condition);
	}
	
	// 行を追加
	function ExecuteInsert($table,$record)
	{
		return $this->db->AutoExecute($table,$record,"INSERT");
	}
	
	// 行を更新
	function ExecuteUpdate($table,$record,$where="")
	{
		return $this->db->AutoExecute($table,$record,"UPDATE",$where);
	}
	
	// 行を削除
	function ExecuteDelete($table,$where="")
	{
		return $this->Execute("delete from ".$table." where ".$where);
	}
	
	// PostgreSQLのselect文をシミュレートしてselect文を実行。
	function SelectLimit($sql,$numrows=-1,$offset=-1,$inputarr=false)
	{
		return $this->db->SelectLimit($sql,$numrows,$offset,$inputarr);
	}
	
	// トランザクション開始
	function StartTrans()
	{
		return $this->db->StartTrans();
	}
	
	// トランザクション完了
	function CompleteTrans()
	{
		if(DB_TYPE == "mysql")
			$this->Execute("unlock tables");
		return $this->db->CompleteTrans();
	}
	
	// テーブルをロック
	function doLock($table)
	{
		if(DB_TYPE == "postgres")
			$this->Execute("lock table ".$table." in share row exclusive mode");
	}
	
	// データベースに送信される文字列をクオート
	function qstr($s)
	{
		return $this->db->qstr($s);
	}
	
	// タイムスタンプを返す
	function DBTimeStamp($timestamp)
	{
		if(is_null($timestamp))
			$timestamp = time();
		return $this->db->DBTimeStamp($timestamp);
	}
}
