<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		CategoryManager.class.php
 * @brief		categoryテーブルの処理を行うクラス
 * @date		2007.01.19
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class CategoryManager extends BitcubeDB
{
	function CategoryManager()
	{
		$this->BitcubeDB();
	}
	
	// カテゴリ情報取得
	function getCategoryInfo($code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->category.category_code ";
		$sql .= " ,$this->category.group_code ";
		$sql .= " ,$this->category.category_name ";
		$sql .= " ,$this->category.category_order ";
		$sql .= " from ";
		$sql .= " $this->category ";
		$sql .= " where $this->category.is_delete = 0 and $this->category.category_code = $code ";
		
		return $this->GetRow($sql);
	}
	
	// カテゴリ情報一覧取得
	function getCategoryList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->category.category_code ";
		$sql .= " ,$this->category.group_code ";
		$sql .= " ,$this->category.category_name ";
		$sql .= " ,$this->category.category_order ";
		$sql .= " from ";
		$sql .= " $this->category ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->category.is_delete = 0 and $condition ":
			" where $this->category.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
	
	// カテゴリ情報追加
	function insCategory($record)
	{
		$record["category_code"] = $this->getNextCategoryCode();
		$record["category_order"] = $this->getNextCategoryOrder($record["group_code"]);
		$record["is_delete"] = 0;
		
		return $this->ExecuteInsert($this->category,$record);
	}
	
	// カテゴリ情報編集
	function updCategory($record,$code)
	{
		return $this->ExecuteUpdate($this->category,$record,"category_code = $code");
	}
	
	// オーダー前後カテゴリコード取得
	function getNextPrevCategory($code,$orderby="",$condition="")
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->category.category_code ";
		$sql .= " ,$this->category.category_order ";
		$sql .= " from ";
		$sql .= " $this->category ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->category.is_delete = 0 and $condition ":
			" where $this->category.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->Execute($sql);
		
		if($rs->RecordCount() > 0)
		{
			while(!$rs->EOF)
			{
				$fields = $rs->fields;
				if($fields["category_code"] == $code)
				{
					$rs->MoveNext();
					if(!$rs->EOF)
					{
						$result["bottom"] = $rs->fields["category_code"];
					}
					break;
				}
				$result["top"] = $fields["category_code"];
				$rs->MoveNext();
			}
		}
		return $result;
	}
	
	// カテゴリ情報オーダー入れ替え
	function cngCategoryOrder($current_code,$target_code)
	{
		$current_order = $this->GetOne("select $this->category.category_order from $this->category where $this->category.category_code = ".$current_code);
		$target_order = $this->GetOne("select $this->category.category_order from $this->category where $this->category.category_code = ".$target_code);
		$record["category_order"] = $target_order;
		$rtn = $this->ExecuteUpdate($this->category,$record,"category_code = ".$current_code);
		$record["category_order"] = $current_order;
		$rtn = $this->ExecuteUpdate($this->category,$record,"category_code = ".$target_code);
		
		return $rtn;
	}
	
	// カテゴリ情報削除
	function delCategory($code)
	{
		$record["is_delete"] = 1;
		if(!$this->ExecuteUpdate($this->entry,$record,"category_code  = $code"))
			return false;
		return $this->ExecuteUpdate($this->category,$record,"category_code = $code");
	}
	
	// 最新コードを取得
	function getLastCategoryCode()
	{
		return $this->GetMax($this->category,"category_code");
	}
	
	// 新規追加されるコードを取得
	function getNextCategoryCode()
	{
		return $this->getLastCategoryCode() + 1;
	}
	
	// 最新オーダーコードを取得
	function getLastCategoryOrder($condition="")
	{
		return $this->GetMax($this->category,"category_code","group_code = ".$condition);
	}
	
	// 新規追加されるオーダーコードを取得
	function getNextCategoryOrder($condition="")
	{
		return $this->getLastCategoryOrder($condition) + 1;
	}
	
	// テーブルをロック
	function Lock()
	{
		$this->doLock($this->category);
	}
}
