<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		RSSInputForm.class.php
 * @brief		RSS設定入力フォームクラス
 * @date		2007.01.23
 */

require_once(CLASS_DIR."/form/AbstractForm.class.php");

class RSSInputForm extends AbstractForm
{
	function setMetaDescription($group_meta_description="")
	{
		$this->group_meta_description = $group_meta_description;
	}
	
	function setRSSOutputNum($group_rss_output_num="")
	{
		$this->group_rss_output_num = $group_rss_output_num;
	}
	
	function setRSS1Output($group_rss1_output="")
	{
		$this->group_rss1_output = $group_rss1_output;
	}
	
	function setRSS2Output($group_rss2_output="")
	{
		$this->group_rss2_output = $group_rss2_output;
	}
	
	function setATOMOutput($group_atom_output="")
	{
		$this->group_atom_output = $group_atom_output;
	}
	
	function setRSS1FileName($group_rss1_file_name="")
	{
		$this->group_rss1_file_name = $group_rss1_file_name;
	}
	
	function setRSS2FileName($group_rss2_file_name="")
	{
		$this->group_rss2_file_name = $group_rss2_file_name;
	}
	
	function setATOMFileName($group_atom_file_name="")
	{
		$this->group_atom_file_name = $group_atom_file_name;
	}
	
	function setRSSCopyright($group_rss_copyright="")
	{
		$this->group_rss_copyright = $group_rss_copyright;
	}
	
	function setRSSCreator($group_rss_creator="")
	{
		$this->group_rss_creator = $group_rss_creator;
	}
	
	function check()
	{
		$error_array = array();
		if(!is_null($this->group_rss_output_num))
			if(!strlen($this->group_rss_output_num))
				$error_array["group_rss_output_num"] = "RDFに出力する記事数を入力してください。";
			else if(!is_num($this->group_rss_output_num))
				$error_array["group_rss_output_num"] = "RDFに出力する記事数を半角数字で入力してください。";
		if(!is_null($this->group_rss1_file_name))
			if(!strlen($this->group_rss1_file_name))
				$error_array["group_rss1_file_name"] = "RSS1.0のファイル名を入力してください。";
			else if(!is_filename($this->group_rss1_file_name))
				$error_array["group_rss1_file_name"] = "RSS1.0のファイル名を半角数字で入力してください。";
		if(!is_null($this->group_rss2_file_name))
			if(!strlen($this->group_rss2_file_name))
				$error_array["group_rss2_file_name"] = "RSS2.0のファイル名を入力してください。";
			else if(!is_filename($this->group_rss2_file_name))
				$error_array["group_rss2_file_name"] = "RSS2.0のファイル名を半角数字で入力してください。";
		if(!is_null($this->group_atom_file_name))
			if(!strlen($this->group_atom_file_name))
				$error_array["group_atom_file_name"] = "ATOMのファイル名を入力してください。";
			else if(!is_filename($this->group_atom_file_name))
				$error_array["group_atom_file_name"] = "ATOMのファイル名を半角数字で入力してください。";
		return $error_array;
	}
}
