<?php
/*
 * $RCSfile: blackboard.js.inc,v $
 * $Date: 2005/07/28 13:38:37 $
 * $Author: die $
 * 
 * Ф 饤¦ץ
 * Υեϡblackboard.html.inc˥󥯥롼ɤ롣
 * 
 * Copyright (c) 2005 die kato
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
?>

/*
 * Ф󥢥ץꥱ
 */
function BlackBoard(name) {
	var b = this;
	var app = name;
	this.b = b;
	this.app = app;
	this.OFFSET_X = <?php echo FRAME_LEFT + BACK_LEFT ?>; // frame.left + back.left
	this.OFFSET_Y = <?php echo FRAME_TOP + BACK_TOP ?>; // frame.top + back.top
	this.IMAGE = "<?php echo get_blackboard_image_name(); ?>";

	/*
	 * 
	 */
	this.initialize = function() {
		this.debug = this.element('debug');
		this.chalk = new this.Chalk();
		this.chalk.initialize();
		this.controller = this.element('boardController');

		this.element('eraser').onclick = function() {
			if (confirm('֤ޤ衣Ǥ')) {
				// ľä
				b.element('eraserForm').action = location.pathname + '?' + (new Date().getTime()) + location.hash;
				b.element('eraserLock').value = "erase";
				return true;
			} else {
				return false;
			}
		};

		// ι
		this.log = this.element('log');
		this.updateLog();

		// Фꥯȥޥ͡
		this.rm = new this.BlackBoardRequestManager();
		this.rm.initialize();
		this.rm.ping();

		// ɥå
		this.controller.onmousedown = function(e) {
			b.chalk.down(b.getMouseX(e), b.getMouseY(e));
		}

		// ɥå
		document.onmousemove = function(e) {
			with (b) {
				if (chalk.isDown) {
					chalk.moveTo(getMouseX(e), getMouseY(e));
				}
			}
		}
	
		// ɥåλ
		document.onmouseup = function(e) {
			with (b) {
				chalk.up();
				if (chalk.points.length > 0) {
					rm.sendScript(chalk.script, chalk.points);
				}
				chalk.initialize();
			}
		}

		// ץ饰ν
		if (this.plugins) {
			for (var i in this.plugins) {
				this.plugins[i].initialize();
			}
		}
	}

	/*
	 * ץåȥե¸ν
	 * ua: 桼̾
	 */
	this.initializeWith = function(ua) {
		this.dynamicLoad('preInitialize', '/platforms/' + ua + '.pre.js');
		this.preInitialize(ua);
	}

	/*
	 * ץåȥե¸ν
	 * ua: 桼̾
	 */
	this.preInitialize = function(ua) {
		if (this.preInitialized) {
			this.initialize();
			// ץåȥե¸ν
			this.dynamicLoad('postInitialize', '/platforms/' + ua + '.post.js');

			this.postInitialize(ua);
			return;
		}
		setTimeout(app + ".preInitialize('" + ua + "')", 500);
	}

	/*
	 * ץåȥե¸ν
	 * ua: 桼̾
	 */
	this.postInitialize = function(ua) {
		if (this.postInitialized) {
			return;
		}
		setTimeout(app + ".postInitialize('" + ua + "')", 500);
	}

	/*
	 * ʥߥå
	 */
	this.dynamicLoad = function(id, file) {
		var path = '<?php echo get_server() . dirname($_SERVER['PHP_SELF']) ?>' + file;
		var script = document.createElement('script');
		script.type = 'text/javascript';
		script.charset = 'EUC-JP';
		script.src = path;
		document.body.appendChild(script);
	}

	/*
	 * Υåץǡ
	 */
	this.updateLog = function() {
		this.log.src = this.IMAGE + "?" + (new Date().getTime());
	}

	/*
	 * rootʲˤ륨ID饨Ȥ
	 * rootꤵʤdocumentʲ鸡
	 * id: ID
	 * root: оݤΥ֥
	 */
	this.element = function(id, root) {
		if (!root) {
			root = document;
		}
		return root.getElementById(id);
	}

	/*
	 * rootʲˤ륿̾饨Ȥ
	 * rootꤵʤdocumentʲ鸡
	 * tagName: ̾
	 * root: оݤΥ֥
	 */
	this.elements = function(tagName, root){
		if (!root) {
			root = document;
		}
		return root.getElementsByTagName(tagName);
	}

	/*
	 * ޥXɸ
	 * e: ٥
	 */
	this.getMouseX = function(e) {
		return e.pageX - this.OFFSET_X;
	}

	/*
	 * ޥYɸ
	 * e: ٥
	 */
	this.getMouseY = function(e) {
		return e.pageY - this.OFFSET_Y;
	}

	/*
	 * ɸx,y
	 * x: Xɸ
	 * y: Yɸ
	 */
	this.createPoint = function(x, y) {
		var point = document.createElement('span');
		point.style.left = "" + x + "px";
		point.style.top = "" + y + "px";
		return point;
	}

	/*
	 * 硼
	 */
	this.Chalk = function() {
		/*
		 * 
		 */
		this.initialize = function() {
			this.isDown = false;
			this.points = new Array();
			//this.chalkCursor = b.element('chalkCursor');
		}
	
		/*
		 * 硼򲼤
		 * x: Xɸ
		 * y: Yɸ
		 */
		this.down = function(x, y) {
			this.script = "";
			this.isDown = true;
			this.moveTo(x, y);
			//this.chalkCursor.style.display = 'inline';
		}
	
		/*
		 * 硼夲
		 */
		this.up = function() {
			this.isDown = false;
			this.script += "l ";
			//this.chalkCursor.style.display = 'none';
		}
	
		/*
		 * 硼ư
		 * x: Xɸ
		 * y: Yɸ
		 */
		this.moveTo = function(x, y) {
			//this.chalkCursor.style.left = point.style.left;
			//this.chalkCursor.style.top = point.style.top;
			var point = b.createPoint(x, y);
			b.controller.appendChild(point);
			this.points.push(point);
			this.script += x + " " + y + " ";
		}
	}

	/*
	 * ꥯȥޥ͡
	 */
	this.RequestManager = function() {
		this.CONTENT_TYPE = "application/x-www-form-urlencoded;charset=EUC-JP";
		this.STATE_UNINITIALIZED = 0;
		this.STATE_COMPLETE = 4;
		this.STATUS_OK = 200;
		this.STATUS_PARTIAL_CONTENT = 206;
		this.STATUS_NOT_MODIFIED = 304;
	
		/*
		 * XMLHttpRequest֥Ȥ
		 */
		this.createXMLHttpRequest = function() {
			if (this.req) {
				return this.req;
			} else {
				return new XMLHttpRequest();
			}
		}

		/*
		 * req椫ɤĴ٤
		 */
		this.isBusy = function() {
			return !(this.req.readyState == this.STATE_UNINITIALIZED ||
			         this.req.readyState == this.STATE_COMPLETE);
		}
	};

	/*
	 * ꥯȥޥͣ͡Υ֥
	 */
	this.RequestManager = new this.RequestManager();

	/*
	 * Фꥯȥޥ͡
	 */
	this.BlackBoardRequestManager = function() {
		this.INTERVAL_MIN = <?php echo $conf['requestmanager_interval_min'] ?>;
		this.INTERVAL_MAX = <?php echo $conf['requestmanager_interval_max'] ?>;

		/*
		 * 
		 */
		this.initialize = function() {
			this.interval = this.INTERVAL_MIN;
			this.req = this.createXMLHttpRequest();
			this.script = "";
			this.points = new Array();
		}
	
		/*
		 * ץ
		 * s: ץ
		 * ds: 
		 */
		this.sendScript = function(s, ds) {
			var req = this.createXMLHttpRequest();
			// Хåեɲ
			if (s != null) {
				this.script += s;
				this.points = this.points.concat(ds);
			}
			// Хåեʤ鲿⤷ʤ
			if (this.script == "") {
				return;
			}
			// ʤ餢Ȥǥȥ饤
			if (this.isBusy()) {
				setTimeout(app + ".rm.sendScript();", this.INTERVAL_MIN);
				return;
			}
			req.onreadystatechange = function() {
				try {
					if (req.readyState == b.rm.STATE_COMPLETE) {
						if (req.status == b.rm.STATUS_OK) {
							b.rm.lastModified = req.responseText;
							b.updateLog();
							b.rm.removePoints(points);
							b.rm.resetPing();
						} else {
							// 顼ʤʤ
							b.rm.script += script;
							b.rm.points = b.rm.points.concat(points);
							setTimeout(app + ".rm.sendScript();", this.INTERVAL_MIN);
						}
					}
				} catch (e) {
					//try { req.abort(); } catch (ae) { }
				}
			}
			try {
				req.open("POST", location.pathname);
				req.setRequestHeader("content-type", this.CONTENT_TYPE);
				var script = this.script;
				var points = this.points;
				this.script = "";
				this.points = new Array();
				req.send("s=" + script);
			} catch (e) {
				try { req.abort(); } catch (ae) { }
			}
		}
	
		/*
		 * ä
		 * points: 
		 */
		this.removePoints = function(points) {
			for (var i in points) {
				try {
					b.controller.removeChild(points[i]);
				} catch (e) {
				}
			}
		}
	
		/*
		 * pingʤ
		 */
		this.resetPing = function() {
			clearInterval(this.pingTimer);
			this.pingTimer = setInterval(app + ".rm.ping();", this.interval);
		}
	
		/*
		 * å
		 */
		this.ping = function() {
			var req = this.createXMLHttpRequest();
			// ʤ齪λ
			if (this.isBusy()) {
				return;
			}
			req.onreadystatechange = function() {
				if (req.readyState == b.rm.STATE_COMPLETE) {
					if (req.status == b.rm.STATUS_PARTIAL_CONTENT) {
						try {
							// Safari: ʤƤstatusǤʤ礬
							var lastModified = req.getResponseHeader("Last-Modified");
							if (b.rm.lastModified != lastModified) {
								b.rm.lastModified = lastModified;
								b.updateLog();
							}
						} catch (e) {
							//try { req.abort(); } catch (ae) { }
						}
						// 󥿡ХǾˤpingʤ
						b.rm.interval = b.rm.INTERVAL_MIN;
						b.rm.resetPing();
					} else {
						if (b.rm.interval < b.rm.INTERVAL_MAX) {
							// 󥿡Х򿭤Фpingʤ
							b.rm.interval += b.rm.INTERVAL_MIN;
						}
						b.rm.resetPing();
					}
				}
			}
			try {
				req.open("HEAD", b.IMAGE);
				if (this.lastModified) {
					req.setRequestHeader("If-Modified-Since", this.lastModified);
				}
				// Safari: HEADΤGETƤޤȤؤн
				req.setRequestHeader("Range", "bytes=0-0");
				req.send(null);
	
				//this.pingTimer = setTimeout(app + ".rm.ping();", this.interval);
			} catch (e) {
				try { req.abort(); } catch (ae) { }
			}
		}
	}
	this.BlackBoardRequestManager.prototype = this.RequestManager;

	/*
	 * ץ饰
	 */
	this.plugins = new Object();
	<?php plugins_render_js(); ?>
}


// Ф󥢥ץꥱͣΥХѿ
var blackBoard;

// 
window.onload = function() {

	blackBoard = new BlackBoard('blackBoard');


	var ua = navigator.userAgent.toLowerCase();

	// GeckoϤSafari
	if (ua.indexOf("gecko") != -1) {
		ua = "gecko"; 
	// Opera
	} else if (ua.indexOf("opera") != -1) {
		ua = "opera"; 
	// IE
	} else if (ua.indexOf("msie") != -1) {
		ua = "ie";
	// ¾
	} else {
		ua = "other";
	}

	// 
	if (ua == "gecko") {
		blackBoard.initialize();
	} else {
		blackBoard.initializeWith(ua);
	}
}
