<?php
/*
*
* $RCSfile: note.inc,v $
* $Date: 2005/07/29 05:05:19 $
* $Author: die $
* 
* Ф Ρ ץ饰
* 
* Copyright (c) 2005 die kato
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
* 02111-1307, USA.
*/

plugin_conf_load('note');

	/*
	 * Ρȥץ饰ξ֤ޤ
	 */
	function note_info() {
		$info = new PluginInfo();
		$info->name = "Ρ";
		$info->author = "die kato, rica, AsO";
		$info->license = "GNU GPL";
		$info->version = "0.2";
		$info->homepage = "http://blackboard.sourceforge.jp/doc/index.php?plugins%2Fnote";
		$info->download = "http://blackboard.sourceforge.jp/doc/index.php?plugins%2Fnote";
		$info->description = "ФƤ¸ץ饰Ǥ";
		return $info;
	}

	/*
	 * 
	 */
	function note_get_conf() {
		?>
			<h3></h3>
			<table>
				<?php
					$order = array("Τ"=>0, "ŤΤ"=>1);
					conf_item_text("⤯ե̾", "note_index", 10);
					conf_item_number("ȥκĹ", "page_title_max_length", 5, "ʸ");
					conf_item_text("ڡեդʸ", "page_image_prefix", 10);
					conf_item_text("ڡեθդʸ", "page_image_suffix", 10);
					conf_item_number("⤯ΥǥեȤη", "note_index_default_num", 5, "");
					conf_item_number("⤯ΥǥեȤγϰ", "note_index_default_start", 5, "");
					conf_select_text("⤯ΥǥեȤθ", "note_index_default_order", $order);
					conf_item_text("⤯ΥǥեȤθʸ", "note_index_default_query", 10);
				?>
			</table>
			<h3>ڡδ</h3>
			<p>
				˥ڡȥѹΤβ̤ͽꡣ
			</p>
		<?php

	}

	/*
	 * 
	 */
	function note_post_conf() {
		global $conf;
		$e = array();
		$order = array(0, 1);
		$e['note_index'] = conf_validate_text('note_index', 100, 1);
		$e['page_title_max_length'] = conf_validate_int('page_title_max_length', 1024, 10);
		$e['page_image_prefix'] = conf_validate_text('page_image_prefix', 64, 1);
		$e['page_image_suffix'] = conf_validate_text('page_image_suffix', 64, 1);
		$e['note_index_default_num'] = conf_validate_int('note_index_default_num', 100, 0);
		$e['note_index_default_start'] = conf_validate_int('note_index_default_start', 1000, 0);
		$e['note_index_default_order'] = conf_validate_select('note_index_default_order', $order);
		$e['note_index_default_query'] = conf_validate_text('note_index_default_query', 1000, 0);

		conf_save('note', $e);
		return $e;
	}

	/*
	 * ΡȤΥ
	 */
	function note_action() {
		if (isset($_POST['t'])) {
			take_note($_POST['t']);
			get_self();
		}
	}

	/*
	 * ФƤΡȤˤĤ
	 * $title: ȥʸ
	 */
	function take_note($title) {
		global $conf;
		// ȥʸ̵
		$title = htmlspecialchars($title);
		$title = strtr($title, "\n", " ");
		$title = strtr($title, "\r", " ");
		$len = mb_strlen($title);
		if ($len > $conf['page_title_max_length'] || $len == 0) {
			return;
		}
		$im = image_create();
		// ĤȥΡȤǤطʤ㤦ᡢȿž
		for ($i = 0; $i < imagecolorstotal($im); $i++) {
			$a = imagecolorsforindex($im, $i);
			imagecolorset($im, $i, 0xff-$a['red'], 0xff-$a['green'], 0xff-$a['blue']);
		}
		$t = time();
		image_save($im, get_page_image_name($t));
		$f = fopen(get_note_index_name(), 'a');
		flock($f, LOCK_EX);
		fputs($f, "" . $t . " " . $title . "\n");
		flock($f, LOCK_UN);
		fclose($f);
	}

	/*
	 * Ρܼե̾μ
	 */
	function get_note_index_name() {
		global $conf;
		return $conf['data_dir'] . $conf['note_index'];
	}

	/*
	 * ڡ̾μ
	 * $time: 
	 */
	function get_page_image_name($time) {
		global $conf;
		return $conf['data_dir'] . $conf['page_image_prefix'] . $time . $conf['page_image_suffix'];
	}

	/*
	 * ڡURIμ
	 */
	function get_page_image_uri($time) {
		return get_server() . dirname($_SERVER['PHP_SELF']) . '/' . get_page_image_name($time);
	}

	/*
	 * ڡURI
	 * $time: 
	 */
	function get_page_uri($date) {
		static $script_uri;
		if (!isset($script_uri)) {
			$script_uri = get_script_uri();
		}
		return $script_uri . '?page=' . $date . '#note';
	}
?>
