<?php
/*
 * $RCSfile: report.xsl.default.inc,v $
 * $Date: 2005/07/04 12:49:48 $
 * $Author: die $
 * 
 * Фݡ RSS  XSLT
 * 
 * Copyright (c) 2005 die kato
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * s program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
	header("Content-type:application/xml");
	echo '<?xml version="1.0" encoding="EUC-JP"?>';
?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns="http://www.w3.org/1999/xhtml"
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:content="http://purl.org/rss/1.0/modules/content/"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:foaf="http://xmlns.com/foaf/0.1/" >

	<xsl:output method="xml"
	            encoding="EUC-JP"
	            indent="yes"
	            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
	            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

	<xsl:template match="/">
		<xsl:apply-templates select="rdf:RDF"/>
	</xsl:template>

	<xsl:template match="rdf:RDF">
		<html xml:lang="ja" lang="ja">
			<head>
				<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=EUC-JP" />
				<title><xsl:value-of select="rss:channel/rss:title"/></title>
				<style type="text/css">
					body {
						margin: 0px;
						padding: 0px;
						font-size: 14px;
						text-align: center;
					}
					a {
						color: #000000;
					}
					h1 {
						font-size: 24px;
						margin: 10px;
						padding: 10px;
					}
					h2 {
						font-size: 18px;
						margin: 5px;
						padding: 5px;
					}
					.description {
						margin:  10px;
					}
					.date {
						text-align: right;
						margin: 10px;
					}
					.page {
						background-image:url(plugins/note/images/notebackground.png);
						width: <?php echo $conf['blackboard_width'] + 20 ?>px;
						height: <?php echo $conf['blackboard_height'] + 100 ?>px;
						text-align: left;
						margin: 20px auto 20px auto;
					}
				</style>
			</head>
			<body>
				<h1><a href="{rss:channel/rss:link}"><xsl:value-of select="rss:channel/rss:title" /></a></h1>
				<p id="description" class="description">
					<xsl:value-of select="rss:channel/rss:description" />
				</p>
				<xsl:apply-templates select="rss:item"/>
				<div id="navigator"></div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="rss:item">
		<div class="page">
			<h2><a href="{rss:link}"><xsl:value-of select="rss:title"/></a></h2>
			<div class="date">
				<xsl:value-of select="dc:date"/>
			</div>
			<div>
				<!--
				ΥɤϡMozilla / Firefoxưʤ
				disable-output-escaping̵뤵Х餷
				<xsl:value-of select="content:encoded" disable-output-escaping="yes" />
				̵ʲΤ褦˻Ū˽
				-->
				<img src="{substring-before(substring-after(content:encoded, '&quot;'), '&quot;')}" alt="{rss:title}" />
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
