/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.sql.format;

import blanco.commons.sql.format.BlancoSqlConstants;
import blanco.commons.sql.format.BlancoSqlToken;
import java.util.ArrayList;

public class BlancoSqlParser {
    String before;
    char ch;
    int pos;
    String[] twoCharacterSymbol = new String[]{"<>", "<=", ">=", "||"};

    BlancoSqlParser() {
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\uffff';
    }

    public static boolean isLetter(char c) {
        if (BlancoSqlParser.isSpace(c)) {
            return false;
        }
        if (BlancoSqlParser.isDigit(c)) {
            return false;
        }
        return !BlancoSqlParser.isSymbol(c);
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isSymbol(char c) {
        switch (c) {
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    BlancoSqlToken nextToken() {
        if (this.pos >= this.before.length()) {
            ++this.pos;
            return new BlancoSqlToken(6, "");
        }
        this.ch = this.before.charAt(this.pos);
        if (BlancoSqlParser.isSpace(this.ch)) {
            String s = "";
            do {
                s = s + this.ch;
                this.ch = this.before.charAt(this.pos);
                if (!BlancoSqlParser.isSpace(this.ch)) {
                    return new BlancoSqlToken(0, s);
                }
                ++this.pos;
            } while (this.pos < this.before.length());
            return new BlancoSqlToken(0, s);
        }
        if (this.ch == ';') {
            ++this.pos;
            return new BlancoSqlToken(1, ";");
        }
        if (BlancoSqlParser.isDigit(this.ch)) {
            String s = "";
            while (BlancoSqlParser.isDigit(this.ch) || this.ch == '.') {
                s = s + this.ch;
                ++this.pos;
                if (this.pos >= this.before.length()) break;
                this.ch = this.before.charAt(this.pos);
            }
            return new BlancoSqlToken(4, s);
        }
        if (BlancoSqlParser.isLetter(this.ch)) {
            String s = "";
            while (BlancoSqlParser.isLetter(this.ch) || BlancoSqlParser.isDigit(this.ch) || this.ch == '.') {
                s = s + this.ch;
                ++this.pos;
                if (this.pos >= this.before.length()) break;
                this.ch = this.before.charAt(this.pos);
            }
            for (int i = 0; i < BlancoSqlConstants.SQL_RESERVED_WORDS.length; ++i) {
                if (s.compareToIgnoreCase(BlancoSqlConstants.SQL_RESERVED_WORDS[i]) != 0) continue;
                return new BlancoSqlToken(2, s);
            }
            return new BlancoSqlToken(3, s);
        }
        if (this.ch == '-') {
            ++this.pos;
            char ch2 = this.before.charAt(this.pos);
            if (ch2 != '-') {
                return new BlancoSqlToken(1, "-");
            }
            ++this.pos;
            String s = "--";
            do {
                this.ch = this.before.charAt(this.pos);
                s = s + this.ch;
                ++this.pos;
            } while (this.ch != '\n');
            return new BlancoSqlToken(5, s);
        }
        if (this.ch == '/') {
            ++this.pos;
            char ch2 = this.before.charAt(this.pos);
            if (ch2 != '*') {
                return new BlancoSqlToken(1, "/");
            }
            String s = "/*";
            ++this.pos;
            int ch0 = -1;
            do {
                ch0 = this.ch;
                this.ch = this.before.charAt(this.pos);
                s = s + this.ch;
                ++this.pos;
            } while (ch0 != 42 || this.ch != '/');
            return new BlancoSqlToken(5, s);
        }
        if (this.ch == '\'') {
            ++this.pos;
            String s = "'";
            do {
                this.ch = this.before.charAt(this.pos);
                s = s + this.ch;
                ++this.pos;
            } while (this.ch != '\'');
            return new BlancoSqlToken(4, s);
        }
        if (this.ch == '\"') {
            ++this.pos;
            String s = "\"";
            do {
                this.ch = this.before.charAt(this.pos);
                s = s + this.ch;
                ++this.pos;
            } while (this.ch != '\"');
            return new BlancoSqlToken(3, s);
        }
        if (BlancoSqlParser.isSymbol(this.ch)) {
            String s = "" + this.ch;
            ++this.pos;
            if (this.pos >= this.before.length()) {
                return new BlancoSqlToken(1, s);
            }
            char ch2 = this.before.charAt(this.pos);
            for (int i = 0; i < this.twoCharacterSymbol.length; ++i) {
                if (this.twoCharacterSymbol[i].charAt(0) != this.ch || this.twoCharacterSymbol[i].charAt(1) != ch2) continue;
                ++this.pos;
                s = s + ch2;
                break;
            }
            return new BlancoSqlToken(1, s);
        }
        ++this.pos;
        return new BlancoSqlToken(7, "" + this.ch);
    }

    ArrayList parse(String before) {
        this.pos = 0;
        this.before = before;
        ArrayList<BlancoSqlToken> list = new ArrayList<BlancoSqlToken>();
        while (true) {
            BlancoSqlToken t = this.nextToken();
            if (t.type == 6) break;
            list.add(t);
        }
        return list;
    }
}

