/*
 * blancoStruts Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.struts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;

/**
 * ^XMLɕϊ܂B
 * 
 * @author ToshikiIga
 */
public class BlancoStrutsMeta2Xml {

    public static void main(String[] args) {
        new File("tmp/struts").mkdirs();
        // System.out.println("^񂩂XMLt@C쐬: Jn");

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(
                    "./meta/blancoStrutsTemplate.xls"));
            outStream = new BufferedOutputStream(new FileOutputStream(
                    "./tmp/struts/aaa.xml"));

            new BlancoStrutsMeta2Xml().process(inStream, outStream);
            outStream.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TransformerException e) {
            e.printStackTrace();
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        // System.out.println("^񂩂XMLt@C쐬: I");
    }

    public void process(InputStream inStreamMetaSource,
            OutputStream outStreamTarget) throws TransformerException,
            IOException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(getClass().getClassLoader()
                    .getResourceAsStream(
                            "blanco/struts/BlancoStrutsMeta2Xml.xml"));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null) {
                inStreamDef.close();
            }
        }
    }
}
