/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.expander.form;

import java.util.Iterator;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.struts.definition.form.FieldValidation;
import blanco.struts.definition.form.FormField;
import blanco.struts.definition.form.FormTable;
import blanco.struts.expander.TypeFactory;
import blanco.struts.expander.form.base.BaseEventValidationMethod;
import blanco.struts.runtime.validator.Validator;
import blanco.struts.runtime.validator.message.ErrorMessageKey;

/**
 * @author Yasuo Nakanishi
 */
public class ValidateRangeEventMethod extends BaseEventValidationMethod {

    public ValidateRangeEventMethod(String event, Iterator eventFields,
            Iterator tableIterator, TypeFactory typeFactory) {
        super(createName(event), event, eventFields, tableIterator, typeFactory);
    }

    public static String createName(String event) {
        NameAdjuster na = getNameAdjuster();
        return createName("validate", "RangeOn" + na.toTitleCase(event));
    }

    public void setupSignature() {
        super.setupSignature();

        String doc = "";

        doc = getName() + "CxgtH[}bg؃\bhB";
        getJavaDoc().addLine(doc);

        doc = "̃\bhActionNXĂяoĂB";
        getJavaDoc().addLine(doc);
    }

    protected void implemntFieldValidation(FormField f, Value result) {
        Value fieldValue = getField(f.getValue().getName());

        Type keyType = getRuntimeType(ErrorMessageKey.class);
        Type validatorType = getRuntimeType(Validator.class);

        boolean rangeCheck = f.getValidation().isCheckRange();
        if (rangeCheck) {
            getImplementor().checkIntRange(f, fieldValue, result, keyType, validatorType);
            getImplementor().emptyLine();
        }
    }

    protected void implementTableValidation(Value item, FormField field,
            Value errors) {
        FieldValidation validation = field.getValidation();

        Type keyType = getRuntimeType(ErrorMessageKey.class);
        Type validatorType = getRuntimeType(Validator.class);

        boolean rangeCheck = validation.isCheckRange();
        if (rangeCheck) {
            getImplementor().checkTableIntRange(item, field, errors, keyType, validatorType);
            getImplementor().emptyLine();
        }
    }

    protected boolean existTableValidation(String event, FormTable table) {
        return table.existEventFormValidationField(event);
    }
}
