package blanco.plugin.strutsee.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import blanco.plugin.strutsee.editors.BlancoStrutsEEEditor;

public class BlancoStrutsEEWizardPage extends WizardPage {

    private Label labelMessage1 = null;

    private Label labelMessage2 = null;

    private ISelection selection;

    public BlancoStrutsEEWizardPage(ISelection selection) {
        super("wizardPage");
        setTitle("blancoStruts Enterprise Editin vOC pxEBU[h");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;

        Composite container = new Composite(parent, SWT.NULL);
        container.setLayout(gridLayout);

        new Label(container, SWT.NONE)
                .setText("blancoStruts Enterprise Edition Wizardւ悤I");
        new Label(container, SWT.NONE)
                .setText("̃EBU[hblancoStruts Enterprise Edition vOCp\ɂȂ܂ł̎菇`܂B");
        new Label(container, SWT.NONE).setText("");
        new Label(container, SWT.NONE).setText("̃EBU[h̎傽ړÍAݒt@C("
                + BlancoStrutsEEEditor.TARGET_FILENAME
                + ")vWFNg̃[gtH_ɍ쐬邱ƂłB");
        new Label(container, SWT.NONE).setText("ݒt@C("
                + BlancoStrutsEEEditor.TARGET_FILENAME
                + ")Ɋւ󋵂͉L̂悤ɂȂĂ܂B");

        labelMessage1 = new Label(container, SWT.NONE);
        labelMessage1.setText("  1.vWFNg̃[gtH_ "
                + BlancoStrutsEEEditor.TARGET_FILENAME + "t@CVKɍ쐬܂B");
        labelMessage2 = new Label(container, SWT.NONE);
        labelMessage2.setText("  2.EBU[h(Finish)sƂɂVK"
                + BlancoStrutsEEEditor.TARGET_FILENAME
                + "t@C쐬ĕҏWsƂł܂B");

        setControl(container);

        IProject proj = BlancoStrutsEEWizard.getProject(selection);
        if (proj == null) {
            setErrorMessage("vWFNgIł");
            setPageComplete(false);
            labelMessage1.setText("  1.vWFNgIĂ܂B");
            labelMessage2.setText("  2.vWFNg̒ɂ "
                    + BlancoStrutsEEEditor.TARGET_FILENAME + "t@C͍쐬ł܂B");
            return;
        }

        if (proj.isOpen() == false) {
            setPageComplete(false);
            setErrorMessage("JĂvWFNgIĂAēxEBU[hsĂB");
            labelMessage1.setText("  1.IꂽvWFNg͊JĂ܂B");
            labelMessage2.setText("  2.vWFNg̒ɂ "
                    + BlancoStrutsEEEditor.TARGET_FILENAME + "t@C͍쐬ł܂B");
            return;
        }

        IFile file = proj.getFile(BlancoStrutsEEEditor.TARGET_FILENAME);
        if (file.exists()) {
            labelMessage1.setText("  1.ɃvWFNg̃[g "
                    + BlancoStrutsEEEditor.TARGET_FILENAME + "t@C݂Ă܂B");
            labelMessage2.setText("  2.EBU[h(Finish)sƂɂ"
                    + BlancoStrutsEEEditor.TARGET_FILENAME
                    + "t@C̕ҏWsƂł܂B");
        }
    }
}