/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class AddListItemMethod extends MethodExpander {
    private String _name = "";
    private String _fieldName = "";
    private Type _itemType = null;

    public AddListItemMethod(String baseName, String fieldName, Type itemType) {
        super(createName(baseName));
        _name = baseName;
        _fieldName = fieldName;
        _itemType = itemType;
        
    }
    
    public void setupSignature() {
        addArgument(createItemArugument());
    }

    private Value createItemArugument() {
        String name = getNameAdjuster().toValueName(_itemType.getName());
        return new Value(_itemType, name);
    }
    
    public static String createName(String baseName) {
        return MethodExpander.createName("add", baseName) ;
    }
    
    private String getArumentName() {
        return getNameAdjuster().toValueName(_itemType.getName());
    }

    public void implement() {
        Implementor i = new Implementor(getData());
        Receiver r = new Receiver(getField(_fieldName));
        Call c = r.call("add");
        c.addArgument(createItemArugument());
        
        i.addStatement(r);
    }
}
