/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.Constructor;

/**
 * @author Yasuo Nakanishi
 */
public class DataStructConstructor extends Constructor {
    private Value[] _argumentValues = null;

    public DataStructConstructor(String type, Value[] values) {
        super(type);
        _argumentValues = values;
    }
    

    public void implement() {
        Implementor implementor = new Implementor(getData());
        
        Value argumentValue = null;
        Value fieldValue = null;
        String fieldName = "";
        for(int i = 0; i < _argumentValues.length; i++) {
            argumentValue = _argumentValues[i];
            fieldName = getNameAdjuster().toFieldName(argumentValue.getName());
            fieldValue = new Value(argumentValue.getType(), fieldName);
            implementor.assign(fieldValue, argumentValue);
        }
    }
}
