/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.StringLiteral;

/**
 * @author Yasuo Nakanishi
 */
public class DataStructField {
    private Value _value = null;
    private Scope _readScope = Scope.PUBLIC;
    private Scope _writeScope = Scope.PUBLIC;
    private boolean _optional = false;
    private String _default = null;
    private String _description = "";

    public DataStructField(Value value) {
        _value = value;
    }

    public DataStructField(Type type, String name) {
        _value = new Value(type, name);
    }

    public DataStructField(Class type, String name) {
        _value = new Value(type, name);
    }

    public boolean isOptional() {
        return _optional;
    }

    public void setOptional(boolean optional) {
        _optional = optional;
    }

    public Value getValue() {
        return _value;
    }

    public Scope getReadScope() {
        return _readScope;
    }

    public Scope getWriteScope() {
        return _writeScope;
    }

    public void setScope(Scope readScope, Scope writeScope) {
        _readScope = readScope;
        _writeScope = writeScope;
    }
    
    public boolean hasDefault() {
        return _default != null;
    }

    public String getDefault() {
        return _default;
    }

    public void setDefault(String defaultValue) {
        Type type = _value.getType();
        if(type.equals(String.class)) {
            _default = new StringLiteral(defaultValue).toString();
        } else  {
            _default = defaultValue;
        }
    }
    
    public String getName() {
        return _value.getName();
    }

    public String getDescription() {
        return _description;
    }
    

    public void setDescription(String description) {
        _description = description;
    }
    

}
