/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class GetListCountMethod extends MethodExpander {
    private String _fieldName = null;

    public GetListCountMethod(String baseName, String fieldName) {
        super(createName(baseName));
        _fieldName = fieldName;
    }

    public void setupSignature() {
        setReturnType(new Type(int.class));
    }

    public static String createName(String baseName) {
        return MethodExpander.createName("get", baseName + "Count");
    }
    public void implement() {
        Implementor i = new Implementor(getData());
        Receiver r = new Receiver(_fieldName);
        r.call("size");
        i.addReturn(r);
    }
}
