/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ReadAccessor extends MethodExpander {
	private Value _value = null;
    private String _name = "";

    public ReadAccessor(Value value) {
        this(value, value.getName());
    }
    
    public ReadAccessor(Value value, String name) {
        super(createName(value));
        _value = value;
        _name = name;
    }
    
    public void setupSignature() {
        setReturnType(_value.getType());
        
        String doc = "";
        getJavaDoc().addLine(_name + " 擾B");
        getJavaDoc().addReturn(_name + "ԂB");
    }

    public static String createName(Value value) {
	    return createName(value.getName());
	}

	public static String createName(String baseName) {
	    return MethodExpander.createName("get", baseName);
	}

	public void implement() {
	    NameAdjuster nt = new NameAdjuster();
	    Implementor i = new Implementor(getData());
        
		i.addReturn(nt.toFieldName(_value.getName()));
	}
}
