/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct.test;

import java.util.Hashtable;
import java.util.Map;

import blanco.core.datastruct.DataStructDefinition;
import blanco.core.datastruct.DataStructField;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Cast;
import blanco.ig.expander.implementor.LongLiteral;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;

/**
 * @author Yasuo Nakanishi
 */
public class FieldTestData {
    private Map _testDataMap = new Hashtable();
    private TestDataFactory _factory = null;
    
    public FieldTestData() {
        
    }
    
    public void createTestData(DataStructDefinition definitoin) {
        _factory = createFactory();
        for(int i = 0; i < definitoin.getFieldCount(); i++) {
            DataStructField field = definitoin.getField(i);
            Statement data = _factory.createData(field);
            _testDataMap.put(field.getValue().getName(), data);
        }
    }

    public Statement getExpactStatement(DataStructField field) {
        Statement result = (Statement) _testDataMap.get(field.getValue().getName());
        return result;
    }

    public Statement getSetterStatement(DataStructField field) {
        Statement result = (Statement) _testDataMap.get(field.getValue().getName());
        if(field.getValue().getType().equals(String.class)) {
	        result = new StringLiteral(result.toString());
	    } else if(field.getValue().getType().equals(short.class)) {
	        Cast cast = new Cast(new Type(short.class));
	        cast.setStatement(result);
	        result = cast;
	    } else if(field.getValue().getType().equals(long.class)) {
	        result = new LongLiteral(result.toString());
	    }
        return result;
    }

    protected TestDataFactory createFactory() {
        return new TestDataFactory();
    }
    
    protected Statement getTestData(DataStructField field) {
        return (Statement) _testDataMap.get(field.getValue().getName());
    }
}
