/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct.test;

import java.util.Date;

import blanco.core.datastruct.DataStructField;
import blanco.core.test.TestDataUtility;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Statement;

/**
 * @author Yasuo Nakanishi
 */
public class TestDataFactory {
    
    protected boolean isSupportedType(Type type) {
        boolean result = false;
		if(type.equals(String.class)){
		    result = true;
		} else if(type.equals(int.class)){
		    result = true;
		} else if(type.equals(Date.class)){
		    result = true;
		} else if(type.equals(short.class)){
		    result = true;
		} else if(type.equals(float.class)){
		    result = true;
        } else if(type.equals(boolean.class)){
            result = true;
        } else if(type.equals(byte[].class)){
            result = true;
		}
        return result;
    }
    
    public Statement createData(DataStructField field){
        Statement result = null;
		Type type = field.getValue().getType();

		if(type.equals(String.class)){
			result = new Statement(type, TestDataUtility.getRandomString(10));		
		} else if(type.equals(boolean.class)){
			result = new Statement(type, String.valueOf(TestDataUtility.getRandomBoolean()));		
		} else if(type.equals(short.class)){
			result = new Statement(type,String.valueOf(TestDataUtility.getRandomShort()));		
		} else if(type.equals(int.class)){
			result = new Statement(type, String.valueOf(TestDataUtility.getRandomInt()));		
		} else if(type.equals(long.class)){
			result = new Statement(type, String.valueOf(TestDataUtility.getRandomLong()));		
		} else if(type.equals(float.class)){
			result = new Statement(type, String.valueOf(TestDataUtility.getRandomFloat()));		
        } else if(type.equals(Date.class)){
            long l = TestDataUtility.getRandomLongForDate();
            result = new Statement(long.class, Long.toString(l));
        } else if(type.equals(byte[].class)){
            byte[] array = TestDataUtility.getRandomByteArray(20);
            result = new Statement(byte[].class, arrayToString(array));
		} else {
			assert false : "T|[gÕ^Cv:" + type.getFullName();
		}
		return result;
	}
    
    private String arrayToString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for(int i = 0; i < bytes.length; i++) {
            sb.append(bytes[i]);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}
