/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.test;

import junit.framework.TestCase;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class TestCaseClass extends ClassExpander {

	private Type _targetType = null;
	private boolean generateSetUp = false;
	private boolean generateTearDown = false;

	public TestCaseClass(Type targetType) {
		super(createType(targetType));
		setSuperClass(new Type(TestCase.class));
		_targetType = targetType;
	}
	
	protected Type getTargetType() {
	    return _targetType;
	}
	
	public static Type createType(Type targetType) {
	    return new Type(targetType.getNameSpace(), targetType.getName() + "Test");
	}

	protected void expandClassStruct() {
		if(isGenerateSetUp()){
			addMethod(createSetUpMethod());
		}

		if(isGenerateTearDown()){
			addMethod(createSetUpMethod());
		}
		
	}
	
	protected SetUpMethod createSetUpMethod(){
		return new SetUpMethod();
	}

	protected TearDownMethod createTearDownMethod(){
		return new TearDownMethod();
	}

	public boolean isGenerateSetUp() {
		return generateSetUp;
	}

	public boolean isGenerateTearDown() {
		return generateTearDown;
	}

	public void setGenerateSetUp(boolean b) {
		generateSetUp = b;
	}

	public void setGenerateTearDown(boolean b) {
		generateTearDown = b;
	}

}
